/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.wares.advancement.AgreementPredicate;
import io.github.mortuusars.wares.block.entity.DeliveryTableBlockEntity;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DeliveryTableTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private final ResourceLocation id;

    public DeliveryTableTrigger(ResourceLocation id) {
        this.id = id;
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.id;
    }

    protected @NotNull TriggerInstance createInstance(@NotNull JsonObject json, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityPredicate.Composite player, @NotNull DeserializationContext conditionsParser) {
        return new TriggerInstance(this.m_7295_(), player, AgreementPredicate.fromJson(json.get("agreement")), NbtPredicate.m_57481_((JsonElement)json.get("agreement_nbt")), LocationPredicate.m_52629_((JsonElement)json.get("location")));
    }

    public void trigger(ServerPlayer player, DeliveryTableBlockEntity tableBlockEntity) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(player, tableBlockEntity));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final AgreementPredicate agreement;
        private final NbtPredicate agreementNbt;
        private final LocationPredicate location;

        public TriggerInstance(ResourceLocation id, EntityPredicate.Composite player, AgreementPredicate agreementPredicate, NbtPredicate agreementNbtPredicate, LocationPredicate locationPredicate) {
            super(id, player);
            this.agreement = agreementPredicate;
            this.agreementNbt = agreementNbtPredicate;
            this.location = locationPredicate;
        }

        public boolean matches(ServerPlayer player, DeliveryTableBlockEntity tableBlockEntity) {
            Level level = tableBlockEntity.m_58904_();
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = tableBlockEntity.m_58899_();
            double x = pos.m_123341_();
            double y = pos.m_123342_();
            double z = pos.m_123343_();
            return this.agreement.matches(tableBlockEntity.getAgreement()) && this.agreementNbt.m_57483_((Tag)tableBlockEntity.getAgreementItem().m_41783_()) && this.location.m_52617_(serverLevel, x, y, z);
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext pConditions) {
            JsonObject jsonobject = super.m_7683_(pConditions);
            jsonobject.add("agreement", this.agreement.serializeToJson());
            jsonobject.add("agreement_nbt", this.agreementNbt.m_57476_());
            jsonobject.add("location", this.location.m_52616_());
            return jsonobject;
        }
    }
}

