/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.github.mortuusars.wares.data.agreement.DeliveryAgreement;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgreementPredicate {
    public static final AgreementPredicate ANY = new AgreementPredicate(null, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_);
    @Nullable
    private final String idPredicate;
    @Nullable
    private final String sealPredicate;
    @NotNull
    private final MinMaxBounds.Ints orderedPredicate;
    @NotNull
    private final MinMaxBounds.Ints deliveredPredicate;
    @NotNull
    private final MinMaxBounds.Ints experiencePredicate;
    @NotNull
    private final MinMaxBounds.Ints deliveryTimePredicate;

    public AgreementPredicate(@Nullable String idPredicate, @Nullable String sealPredicate, @NotNull MinMaxBounds.Ints orderedPredicate, @NotNull MinMaxBounds.Ints deliveredPredicate, @NotNull MinMaxBounds.Ints experiencePredicate, @NotNull MinMaxBounds.Ints deliveryTimePredicate) {
        this.idPredicate = idPredicate;
        this.sealPredicate = sealPredicate;
        this.orderedPredicate = orderedPredicate;
        this.deliveredPredicate = deliveredPredicate;
        this.experiencePredicate = experiencePredicate;
        this.deliveryTimePredicate = deliveryTimePredicate;
    }

    public boolean matches(DeliveryAgreement agreement) {
        if (this == ANY) {
            return true;
        }
        if (this.idPredicate != null && !this.idPredicate.equals(agreement.getId())) {
            return false;
        }
        if (this.sealPredicate != null && !this.sealPredicate.equals(agreement.getSeal())) {
            return false;
        }
        return this.orderedPredicate.m_55390_(agreement.getOrdered()) && this.deliveredPredicate.m_55390_(agreement.getDelivered()) && this.experiencePredicate.m_55390_(agreement.getExperience()) && this.deliveryTimePredicate.m_55390_(agreement.getDeliveryTime());
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject json = new JsonObject();
        if (this.idPredicate != null) {
            json.addProperty("id", this.idPredicate);
        }
        if (this.sealPredicate != null) {
            json.addProperty("seal", this.sealPredicate);
        }
        json.add("ordered", this.orderedPredicate.m_55328_());
        json.add("delivered", this.deliveredPredicate.m_55328_());
        json.add("experience", this.experiencePredicate.m_55328_());
        json.add("delivery_time", this.deliveryTimePredicate.m_55328_());
        return json;
    }

    public static AgreementPredicate fromJson(@Nullable JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return ANY;
        }
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"agreement");
        return new AgreementPredicate(json.has("id") ? GsonHelper.m_13805_((JsonElement)json, (String)"id") : null, json.has("seal") ? GsonHelper.m_13805_((JsonElement)json, (String)"seal") : null, MinMaxBounds.Ints.m_55373_((JsonElement)json.get("ordered")), MinMaxBounds.Ints.m_55373_((JsonElement)json.get("delivered")), MinMaxBounds.Ints.m_55373_((JsonElement)json.get("experience")), MinMaxBounds.Ints.m_55373_((JsonElement)json.get("delivery_time")));
    }
}

