/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.wares;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.wares.advancement.DeliveryTableTrigger;
import io.github.mortuusars.wares.block.CardboardBoxBlock;
import io.github.mortuusars.wares.block.DeliveryTableBlock;
import io.github.mortuusars.wares.block.PackageBlock;
import io.github.mortuusars.wares.block.entity.DeliveryTableBlockEntity;
import io.github.mortuusars.wares.block.entity.PackageBlockEntity;
import io.github.mortuusars.wares.config.Config;
import io.github.mortuusars.wares.item.CardboardBoxItem;
import io.github.mortuusars.wares.item.DeliveryAgreementItem;
import io.github.mortuusars.wares.item.PackageItem;
import io.github.mortuusars.wares.item.SealedDeliveryAgreementItem;
import io.github.mortuusars.wares.menu.CardboardBoxMenu;
import io.github.mortuusars.wares.menu.DeliveryTableMenu;
import io.github.mortuusars.wares.world.VillageStructures;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="wares")
public class Wares {
    public static final String ID = "wares";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Wares() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Config.init();
        modEventBus.addListener(Config::onConfigLoad);
        modEventBus.addListener(Config::onConfigReload);
        Blocks.BLOCKS.register(modEventBus);
        BlockEntities.BLOCK_ENTITIES.register(modEventBus);
        MenuTypes.MENU_TYPES.register(modEventBus);
        Items.ITEMS.register(modEventBus);
        Villagers.POI_TYPES.register(modEventBus);
        Villagers.PROFESSIONS.register(modEventBus);
        SoundEvents.SOUNDS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(VillageStructures::addVillageStructures);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static class Blocks {
        private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"wares");
        public static final RegistryObject<DeliveryTableBlock> DELIVERY_TABLE = BLOCKS.register("delivery_table", () -> new DeliveryTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_155949_(MaterialColor.f_76362_).m_60978_(2.0f)));
        public static final RegistryObject<CardboardBoxBlock> CARDBOARD_BOX = BLOCKS.register("cardboard_box", () -> new CardboardBoxBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundTypes.CARDBOARD).m_155949_(MaterialColor.f_76362_).m_60978_(0.4f)));
        public static final RegistryObject<PackageBlock> PACKAGE = BLOCKS.register("package", () -> new PackageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundTypes.CARDBOARD).m_155949_(MaterialColor.f_76362_).m_60978_(0.6f)));
    }

    public static class BlockEntities {
        private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"wares");
        public static final RegistryObject<BlockEntityType<DeliveryTableBlockEntity>> DELIVERY_TABLE = BLOCK_ENTITIES.register("delivery_table", () -> BlockEntityType.Builder.m_155273_(DeliveryTableBlockEntity::new, (Block[])new Block[]{(Block)Blocks.DELIVERY_TABLE.get()}).m_58966_(null));
        public static final RegistryObject<BlockEntityType<PackageBlockEntity>> PACKAGE = BLOCK_ENTITIES.register("package", () -> BlockEntityType.Builder.m_155273_(PackageBlockEntity::new, (Block[])new Block[]{(Block)Blocks.PACKAGE.get()}).m_58966_(null));
    }

    public static class MenuTypes {
        private static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"wares");
        public static final RegistryObject<MenuType<DeliveryTableMenu>> DELIVERY_TABLE = MENU_TYPES.register("delivery_table", () -> IForgeMenuType.create(DeliveryTableMenu::fromBuffer));
        public static final RegistryObject<MenuType<CardboardBoxMenu>> CARDBOARD_BOX = MENU_TYPES.register("cardboard_box", () -> IForgeMenuType.create(CardboardBoxMenu::fromBuffer));
    }

    public static class Items {
        private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"wares");
        public static final RegistryObject<SealedDeliveryAgreementItem> SEALED_DELIVERY_AGREEMENT = ITEMS.register("sealed_delivery_agreement", () -> new SealedDeliveryAgreementItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41487_(1)));
        public static final RegistryObject<DeliveryAgreementItem> DELIVERY_AGREEMENT = ITEMS.register("delivery_agreement", () -> new DeliveryAgreementItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41487_(1)));
        public static final RegistryObject<DeliveryAgreementItem> COMPLETED_DELIVERY_AGREEMENT = ITEMS.register("completed_delivery_agreement", () -> new DeliveryAgreementItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41487_(1)));
        public static final RegistryObject<DeliveryAgreementItem> EXPIRED_DELIVERY_AGREEMENT = ITEMS.register("expired_delivery_agreement", () -> new DeliveryAgreementItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41487_(1)));
        public static final RegistryObject<BlockItem> DELIVERY_TABLE = ITEMS.register("delivery_table", () -> new BlockItem((Block)Blocks.DELIVERY_TABLE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
        public static final RegistryObject<CardboardBoxItem> CARDBOARD_BOX = ITEMS.register("cardboard_box", () -> new CardboardBoxItem((Block)Blocks.CARDBOARD_BOX.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
        public static final RegistryObject<PackageItem> PACKAGE = ITEMS.register("package", () -> new PackageItem((Block)Blocks.PACKAGE.get(), new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40750_)));
    }

    public static class Villagers {
        public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"wares");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"wares");
        public static final RegistryObject<PoiType> DELIVERY_TABLE_POI = POI_TYPES.register(Blocks.DELIVERY_TABLE.getId().m_135815_(), () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((DeliveryTableBlock)((Object)((Object)Blocks.DELIVERY_TABLE.get()))).m_49965_().m_61056_()), 1, 1));
        public static final RegistryObject<VillagerProfession> PACKAGER = PROFESSIONS.register("packager", () -> new VillagerProfession("packager", poi -> poi.m_203565_(Objects.requireNonNull(DELIVERY_TABLE_POI.getKey())), poi -> poi.m_203565_(Objects.requireNonNull(DELIVERY_TABLE_POI.getKey())), ImmutableSet.of(), ImmutableSet.of(), null));
    }

    public static class SoundEvents {
        private static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"wares");
        public static final RegistryObject<SoundEvent> PAPER_TEAR = SoundEvents.registerSound("item", "paper.tear");
        public static final RegistryObject<SoundEvent> PAPER_CRACKLE = SoundEvents.registerSound("item", "paper.crackle");
        public static final RegistryObject<SoundEvent> CARDBOARD_PLACE = SoundEvents.registerSound("block", "cardboard.place");
        public static final RegistryObject<SoundEvent> CARDBOARD_BREAK = SoundEvents.registerSound("block", "cardboard.break");
        public static final RegistryObject<SoundEvent> CARDBOARD_HIT = SoundEvents.registerSound("block", "cardboard.hit");
        public static final RegistryObject<SoundEvent> CARDBOARD_FALL = SoundEvents.registerSound("block", "cardboard.fall");
        public static final RegistryObject<SoundEvent> CARDBOARD_STEP = SoundEvents.registerSound("block", "cardboard.step");
        public static final RegistryObject<SoundEvent> WRITING = SoundEvents.registerSound("block", "delivery_table.writing");
        public static final RegistryObject<SoundEvent> DELIVERY_TABLE_OPEN = SoundEvents.registerSound("block", "delivery_table.open");
        public static final RegistryObject<SoundEvent> DELIVERY_TABLE_CLOSE = SoundEvents.registerSound("block", "delivery_table.close");
        public static final RegistryObject<SoundEvent> CARDBOARD_BOX_USE = SoundEvents.registerSound("block", "cardboard_box.use");
        public static final RegistryObject<SoundEvent> VILLAGER_WORK_PACKAGER = SoundEvents.registerSound("entity", "villager.work_packager");

        private static RegistryObject<SoundEvent> registerSound(String category, String key) {
            Preconditions.checkState((category != null && category.length() > 0 ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && key.length() > 0 ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return SOUNDS.register(path, () -> new SoundEvent(Wares.resource(path)));
        }
    }

    public static class Tags {

        public static class Items {
            public static final TagKey<Item> AGREEMENTS = ItemTags.create((ResourceLocation)Wares.resource("agreements"));
            public static final TagKey<Item> DELIVERY_BOXES = ItemTags.create((ResourceLocation)Wares.resource("delivery_boxes"));
            public static final TagKey<Item> CARDBOARD_BOX_BLACKLISTED = ItemTags.create((ResourceLocation)Wares.resource("cardboard_box_blacklisted"));
        }
    }

    public static class AdvancementTriggers {
        public static DeliveryTableTrigger BATCH_DELIVERED = new DeliveryTableTrigger(Wares.resource("batch_delivered"));
        public static DeliveryTableTrigger AGREEMENT_COMPLETED = new DeliveryTableTrigger(Wares.resource("agreement_completed"));
        public static DeliveryTableTrigger AGREEMENT_EXPIRED = new DeliveryTableTrigger(Wares.resource("agreement_expired"));

        public static void register() {
            CriteriaTriggers.m_10595_((CriterionTrigger)BATCH_DELIVERED);
            CriteriaTriggers.m_10595_((CriterionTrigger)AGREEMENT_COMPLETED);
            CriteriaTriggers.m_10595_((CriterionTrigger)AGREEMENT_EXPIRED);
        }
    }

    public static class Stats {
        private static final Map<ResourceLocation, StatFormatter> STATS = new HashMap<ResourceLocation, StatFormatter>();
        public static final ResourceLocation SEALED_LETTERS_OPENED = Stats.register(Wares.resource("sealed_letters_opened"), StatFormatter.f_12873_);
        public static final ResourceLocation PACKAGES_OPENED = Stats.register(Wares.resource("packages_opened"), StatFormatter.f_12873_);
        public static final ResourceLocation INTERACT_WITH_DELIVERY_TABLE = Stats.register(Wares.resource("interact_with_delivery_table"), StatFormatter.f_12873_);

        private static ResourceLocation register(ResourceLocation location, StatFormatter formatter) {
            STATS.put(location, formatter);
            return location;
        }

        public static void register() {
            STATS.forEach((location, formatter) -> {
                Registry.m_122965_((Registry)Registry.f_122832_, (ResourceLocation)location, (Object)location);
                net.minecraft.stats.Stats.f_12988_.m_12899_(location, formatter);
            });
        }
    }

    public static class SoundTypes {
        public static final SoundType CARDBOARD = new ForgeSoundType(1.0f, 1.0f, SoundEvents.CARDBOARD_BREAK, SoundEvents.CARDBOARD_STEP, SoundEvents.CARDBOARD_PLACE, SoundEvents.CARDBOARD_HIT, SoundEvents.CARDBOARD_FALL);
    }
}

