/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.mpfui.renderable;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public abstract class MPFRenderable<T extends MPFRenderable<T>>
extends AbstractWidget {
    protected VisibilityPredicate<T> visibilityPredicate = (renderable, poseStack, mouseX, mouseY) -> true;
    protected Supplier<Component> tooltip = Component::m_237119_;
    protected int tooltipWidth = 220;

    public MPFRenderable(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    public MPFRenderable(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_());
    }

    public abstract T getThis();

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.HINT, this.m_6035_());
    }

    public T setTooltip(Supplier<Component> tooltip) {
        this.tooltip = tooltip;
        return this.getThis();
    }

    public T setTooltip(Component tooltip) {
        this.tooltip = () -> tooltip;
        return this.getThis();
    }

    public T setTooltipWidth(int tooltipWidth) {
        this.tooltipWidth = tooltipWidth;
        return this.getThis();
    }

    public T visibility(VisibilityPredicate<T> predicate) {
        this.visibilityPredicate = predicate;
        return this.getThis();
    }

    public boolean isVisible(PoseStack poseStack, int mouseX, int mouseY) {
        return this.f_93624_ && this.visibilityPredicate.isVisible(this.getThis(), poseStack, mouseX, mouseY);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible(poseStack, mouseX, mouseY)) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTick);
            if (this.m_198029_()) {
                this.m_7428_(poseStack, mouseX, mouseY);
            }
        }
    }

    public void m_7428_(@NotNull PoseStack pPoseStack, int pMouseX, int pMouseY) {
        Component tooltipComponent = this.tooltip.get();
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!Objects.equals(tooltipComponent, Component.m_237119_()) && screen != null) {
            screen.m_96617_(pPoseStack, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)tooltipComponent, this.tooltipWidth), pMouseX, pMouseY);
        }
    }

    public static interface VisibilityPredicate<T extends MPFRenderable<?>> {
        public boolean isVisible(T var1, PoseStack var2, int var3, int var4);
    }
}

