/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.vitalize.blocks;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.api.menu.ExtraDataMenuProvider;
import earth.terrarium.vitalize.api.LootTableUtils;
import earth.terrarium.vitalize.api.ModifiedLootContext;
import earth.terrarium.vitalize.api.PylonType;
import earth.terrarium.vitalize.blocks.BasePylonBlock;
import earth.terrarium.vitalize.blocks.SoulRevitalizerMenu;
import earth.terrarium.vitalize.registry.VitalizeBlocks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import me.codexadrian.spirit.data.Tier;
import me.codexadrian.spirit.entity.EntityRarity;
import me.codexadrian.spirit.registry.SpiritItems;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

@ParametersAreNonnullByDefault
public class SoulRevitalizerBlockEntity
extends BlockEntity
implements EnergyBlock,
WorldlyContainer,
IAnimatable,
ContainerData,
ExtraDataMenuProvider {
    public static final int TICK_TIME = 0;
    public static final int MAX_TICK_TIME = 1;
    public static final int ENERGY = 2;
    public static final int MAX_ENERGY = 3;
    public static final int ENERGY_CONSUMPTION = 4;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final List<BasePylonBlock> pylons = new ArrayList<BasePylonBlock>();
    private InsertOnlyEnergyContainer energyContainer;
    private int maxTickTime;
    private int tickTime;
    private int maxEnergy;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final List<BlockPos> PYLON_POSITIONS = List.of(new BlockPos(-3, 0, 3), new BlockPos(-3, 0, -3), new BlockPos(3, 0, -3), new BlockPos(3, 0, 3), new BlockPos(4, 0, 0), new BlockPos(-4, 0, 0), new BlockPos(0, 0, 4), new BlockPos(0, 0, -4));

    public SoulRevitalizerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(VitalizeBlocks.SOUL_REVITALIZER_ENTITY.get(), blockPos, blockState);
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.tickTime = compoundTag.m_128451_("BurnTime");
        this.maxTickTime = compoundTag.m_128451_("MaxBurnTime");
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.inventory);
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128405_("BurnTime", this.tickTime);
        compoundTag.m_128405_("MaxBurnTime", this.maxTickTime);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.inventory);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ModifiedLootContext modifyContext(ModifiedLootContext context) {
        SoulRevitalizerBlockEntity.checkAndRun(this.pylons, pylon -> pylon.modifyLootContext(context));
        return context;
    }

    public ObjectArrayList<ItemStack> modifyLootTable(ObjectArrayList<ItemStack> itemStacks) {
        SoulRevitalizerBlockEntity.checkAndRun(this.pylons, pylon -> pylon.modifyLootTable(itemStacks, (ServerLevel)this.m_58904_(), this.getEntityType()));
        return itemStacks;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, SoulRevitalizerBlockEntity blockEntity) {
        block6: {
            ServerLevel serverLevel;
            block8: {
                Tier tier;
                block9: {
                    block7: {
                        if (!(level instanceof ServerLevel)) break block6;
                        serverLevel = (ServerLevel)level;
                        if (blockEntity.maxTickTime > 0 || !blockEntity.validate()) break block7;
                        if (blockEntity.getEntityType() == null) {
                            return;
                        }
                        if (blockEntity.getEnergyStorage().getStoredEnergy() <= (long)blockEntity.getDefaultEnergyCost()) {
                            return;
                        }
                        blockEntity.maxTickTime = blockEntity.getDefaultTickTime();
                        blockEntity.maxEnergy = blockEntity.getDefaultEnergyCost();
                        SoulRevitalizerBlockEntity.checkAndRun(blockEntity.pylons, pylon -> pylon.onStart(blockEntity));
                        blockEntity.m_6596_();
                        level.m_7260_(blockPos, blockState, blockState, 3);
                        break block6;
                    }
                    if (blockEntity.getMaxTickTime() <= 0) break block8;
                    if (!(level.m_46467_() % 5L != 0L && blockEntity.getEnergyStorage().getStoredEnergy() >= (long)blockEntity.getEnergyCost() || blockEntity.getEntityType() != null && blockEntity.validate() && blockEntity.getEnergyStorage().getStoredEnergy() >= (long)blockEntity.getEnergyCost())) {
                        blockEntity.clear();
                        return;
                    }
                    if (blockEntity.getEntityType() == null) break block6;
                    if (blockEntity.tickTime >= blockEntity.getMaxTickTime()) break block9;
                    ++blockEntity.tickTime;
                    blockEntity.getEnergyStorage().extractEnergy((long)blockEntity.getEnergyCost(), false);
                    if (level.m_46467_() % 5L == 0L) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)blockPos.m_7494_().m_123341_() + 0.5, (double)blockPos.m_7494_().m_123342_() + 0.3, (double)blockPos.m_7494_().m_123343_() + 0.5, 2, 0.01, 0.01, 0.01, 0.01);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)blockPos.m_7494_().m_123341_() + 0.5, (double)blockPos.m_7494_().m_123342_() + 0.3, (double)blockPos.m_7494_().m_123343_() + 0.5, 2, 0.01, 0.01, 0.01, 0.01);
                        blockEntity.summonParticles(serverLevel);
                    }
                    break block6;
                }
                blockEntity.clear();
                if (!blockEntity.validate() || (tier = SoulUtils.getTier((ItemStack)blockEntity.getCrystal(), (Level)level)) == null) break block6;
                ObjectArrayList<ItemStack> lootTable = LootTableUtils.getLootTable(blockEntity, serverLevel, tier.spawnCount());
                Direction containerDir = SoulRevitalizerBlockEntity.findNearestContainer(level, blockPos);
                SoulRevitalizerBlockEntity.checkAndRun(blockEntity.pylons, pylon -> pylon.onEnd(lootTable, blockEntity));
                if (containerDir == null) break block6;
                SoulRevitalizerBlockEntity.handleItemInsertion(level, level.m_7702_(blockPos.m_121945_(containerDir)), containerDir.m_122424_(), lootTable);
                break block6;
            }
            if (!blockEntity.validatePylons() && serverLevel.m_46467_() % 5L == 0L) {
                for (BlockPos pos : PYLON_POSITIONS) {
                    BlockPos offset = blockPos.m_121955_((Vec3i)pos);
                    if (serverLevel.m_8055_(offset).m_60734_() instanceof BasePylonBlock) continue;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)offset.m_123341_() + 0.5, (double)offset.m_123342_() + 0.5, (double)offset.m_123343_() + 0.5, 10, 0.01, 0.01, 0.01, 0.01);
                }
            }
        }
    }

    public void summonParticles(ServerLevel serverLevel) {
        for (BlockPos pos : PYLON_POSITIONS) {
            float progress = 1.0f - (float)this.tickTime / (float)this.getMaxTickTime();
            Vec3 offset = Vec3.m_82512_((Vec3i)this.m_58899_()).m_82520_((double)((float)pos.m_123341_() * progress), 0.75, (double)((float)pos.m_123343_() * progress));
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123745_, offset.m_7096_(), offset.m_7098_(), offset.m_7094_(), 2, 0.01, 0.01, 0.01, 0.01);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, offset.m_7096_(), offset.m_7098_(), offset.m_7094_(), 2, 0.01, 0.01, 0.01, 0.01);
        }
    }

    public boolean validate() {
        return this.validatePylons() && this.validateInventories();
    }

    public boolean validateInventories() {
        if (this.m_58904_() == null) {
            return false;
        }
        Direction containerDir = SoulRevitalizerBlockEntity.findNearestContainer(this.m_58904_(), this.m_58899_());
        return containerDir != null && SoulRevitalizerBlockEntity.hasSpace(this.m_58904_().m_7702_(this.m_58899_().m_121945_(containerDir)), containerDir.m_122424_());
    }

    public void clear() {
        if (this.m_58904_() == null) {
            return;
        }
        this.tickTime = 0;
        this.maxTickTime = 0;
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public static Direction findNearestContainer(Level level, BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = blockPos.m_121945_(direction);
            BlockEntity blockEntity = level.m_7702_(offsetPos);
            if (blockEntity == null || !SoulRevitalizerBlockEntity.isContainer(blockEntity, direction.m_122424_()) || !SoulRevitalizerBlockEntity.hasSpace(blockEntity, direction.m_122424_())) continue;
            return direction;
        }
        return null;
    }

    public static boolean isContainer(BlockEntity blockEntity, Direction direction) {
        return blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).isPresent();
    }

    public static boolean hasSpace(BlockEntity container, Direction direction) {
        return container.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)((Item)SpiritItems.SOUL_CRYSTAL_SHARD.get()).m_7968_(), (boolean)true).m_41619_()).orElse(false);
    }

    public static void handleItemInsertion(Level level, BlockEntity container, Direction direction, ObjectArrayList<ItemStack> items) {
        container.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).ifPresent(iItemHandler -> {
            for (ItemStack item : items) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)item, (boolean)false);
            }
        });
    }

    public static void checkAndRun(List<BasePylonBlock> pylons, Consumer<PylonType> consumer) {
        HashMap<ResourceLocation, Integer> amount = new HashMap<ResourceLocation, Integer>();
        for (BasePylonBlock pylon : pylons) {
            if (amount.merge(pylon.getType().getId(), 1, Integer::sum) > pylon.getType().maxLevel()) continue;
            consumer.accept(pylon.getType());
        }
    }

    public boolean validatePylons() {
        this.pylons.clear();
        if (this.m_58904_() != null) {
            for (BlockPos pylonPosition : PYLON_POSITIONS) {
                BlockPos offset = this.m_58899_().m_121955_((Vec3i)pylonPosition);
                Block block = this.m_58904_().m_8055_(offset).m_60734_();
                if (!(block instanceof BasePylonBlock)) {
                    this.pylons.clear();
                    return false;
                }
                this.pylons.add((BasePylonBlock)block);
            }
            return true;
        }
        return false;
    }

    public void setMaxTickTime(int maxTickTime) {
        this.maxTickTime = maxTickTime;
    }

    public void setMaxEnergy(int maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    public int getMaxTickTime() {
        return this.maxTickTime;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public EntityType<?> getEntityType() {
        String soulCrystalType;
        if (!this.getCrystal().m_41619_() && (soulCrystalType = SoulUtils.getSoulCrystalType((ItemStack)this.getCrystal())) != null) {
            return EntityType.m_20632_((String)soulCrystalType).orElse(null);
        }
        return null;
    }

    public ItemStack getCrystal() {
        return this.m_8020_(0);
    }

    public int getDefaultTickTime() {
        Tier tier;
        if (this.m_58904_() != null && (tier = SoulUtils.getTier((ItemStack)this.getCrystal(), (Level)this.m_58904_())) != null) {
            return 2 * (tier.minSpawnDelay() + tier.maxSpawnDelay());
        }
        return 0;
    }

    public int getDefaultEnergyCost() {
        Tier tier;
        if (this.m_58904_() != null && (tier = SoulUtils.getTier((ItemStack)this.getCrystal(), (Level)this.m_58904_())) != null) {
            return (int)(EntityRarity.getRarity(this.getEntityType()).energyModifer * (double)tier.spawnRange() * (double)tier.spawnCount() * (double)this.getMaxTickTime());
        }
        return 0;
    }

    public int[] m_7071_(@NotNull Direction direction) {
        return new int[0];
    }

    public boolean m_7155_(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int i, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return false;
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.inventory.isEmpty();
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    public ItemStack m_7407_(int i, int j) {
        return ContainerHelper.m_18969_(this.inventory, (int)i, (int)j);
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.inventory, (int)i);
    }

    public void m_6836_(int i, @NotNull ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
    }

    public boolean m_6542_(Player player) {
        return player.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) <= 64.0;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "spin_cycle", 0.0f, event -> {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.soul_translator.spin", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int getEnergyCost() {
        return this.getMaxTickTime() == 0 ? 0 : this.getMaxEnergy() / this.getMaxTickTime();
    }

    public int m_6413_(int i) {
        return switch (i) {
            case 0 -> this.tickTime;
            case 1 -> this.maxTickTime;
            case 2 -> (int)this.getEnergyStorage().getStoredEnergy();
            case 3 -> (int)this.getEnergyStorage().getMaxCapacity();
            case 4 -> this.getEnergyCost();
            default -> 0;
        };
    }

    public void m_8050_(int i, int j) {
    }

    public int m_6499_() {
        return 5;
    }

    public void writeExtraData(ServerPlayer player, FriendlyByteBuf buffer) {
        buffer.writeBoolean(!this.validatePylons());
        buffer.writeBoolean(!this.validateInventories());
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory inventory, @NotNull Player player) {
        return new SoulRevitalizerMenu((Container)this, this, i, inventory, !this.validatePylons(), !this.validateInventories());
    }

    public InsertOnlyEnergyContainer getEnergyStorage() {
        if (this.energyContainer == null) {
            this.energyContainer = new InsertOnlyEnergyContainer((Updatable)this, 1000000L);
        }
        return this.energyContainer;
    }

    public void update() {
        this.m_6596_();
    }
}

