/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames_common_fabric.util;

import com.natamus.collective_common_fabric.data.GlobalVariables;
import com.natamus.collective_common_fabric.functions.DataFunctions;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import com.natamus.villagernames_common_fabric.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class Names {
    public static List<String> customVillagerNames = new ArrayList<String>();

    public static void setCustomNames() throws IOException {
        String dirpath = DataFunctions.getConfigDirectory() + File.separator + "villagernames";
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "customnames.txt");
        if (dir.isDirectory() && file.isFile()) {
            Path customNamePath = Paths.get(dirpath + File.separator + "customnames.txt", new String[0]);
            String cn = Files.readString(customNamePath);
            if (StringFunctions.sequenceCount((String)cn, (String)",") == 2 && cn.contains("Rick") && cn.contains("Bob") && cn.contains("Eve")) {
                FileChannel.open(customNamePath, StandardOpenOption.WRITE).truncate(0L).close();
            } else {
                String[] cns;
                cn = cn.replace("\n", "").replace("\r", "").strip();
                for (String n : cns = cn.split(",")) {
                    String name = n.strip();
                    if (name.isEmpty()) continue;
                    customVillagerNames.add(name);
                }
            }
        } else {
            boolean ignored = dir.mkdirs();
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "customnames.txt", StandardCharsets.UTF_8);
            writer.close();
        }
    }

    public static String getRandomName() {
        ArrayList<String> villagerNameList = new ArrayList<String>();
        if (ConfigHandler.useCustomNames && !customVillagerNames.isEmpty()) {
            if (ConfigHandler.useBothCustomAndDefaultNames) {
                villagerNameList.add(Names.randomFromList(customVillagerNames));
            } else {
                String name2 = Names.randomFromList(customVillagerNames);
                if (ConfigHandler.shouldCapitalizeNames) {
                    return StringFunctions.capitalizeEveryWord((String)name2);
                }
                return name2;
            }
        }
        if (ConfigHandler.useDefaultFemaleNames) {
            villagerNameList.add(Names.randomFromList(GlobalVariables.femaleNames));
        }
        if (ConfigHandler.useDefaultMaleNames) {
            villagerNameList.add(Names.randomFromList(GlobalVariables.maleNames));
        }
        villagerNameList.removeIf(name -> name.equals(""));
        if (villagerNameList.isEmpty()) {
            return "";
        }
        String name3 = Names.randomFromList(villagerNameList);
        if (ConfigHandler.shouldCapitalizeNames) {
            return StringFunctions.capitalizeEveryWord((String)name3);
        }
        return name3;
    }

    private static String randomFromList(List<String> list) {
        if (list.size() == 0) {
            return "";
        }
        return list.get(GlobalVariables.random.nextInt(list.size()));
    }
}

