/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class ItemStackUtils {
    public static void shrinkStack(@Nullable Player player, ItemStack stack) {
        ItemStackUtils.shrinkStack(player, stack, 1);
    }

    public static void shrinkStack(@Nullable Player player, ItemStack stack, int count) {
        if (player == null || !player.m_7500_()) {
            stack.m_41774_(count);
        }
    }

    public static ItemStack transferEnchantments(ItemStack oldStack, ItemStack newStack) {
        if (!EnchantmentHelper.m_44831_((ItemStack)oldStack).isEmpty()) {
            EnchantmentHelper.m_44831_((ItemStack)oldStack).forEach((arg_0, arg_1) -> ((ItemStack)newStack).m_41663_(arg_0, arg_1));
        }
        return newStack;
    }

    public static boolean hasStackEnchantment(ItemStack stack, Enchantment enchantment) {
        return ItemStackUtils.hasStackEnchantment(stack, Collections.singletonList(enchantment));
    }

    public static boolean hasStackEnchantment(ItemStack stack, List<Enchantment> enchantments) {
        for (Enchantment itemEnchantment : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
            for (Enchantment enchantment : enchantments) {
                if (itemEnchantment != enchantment) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack removeEnchantments(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41749_("Enchantments");
        copy.m_41749_("StoredEnchantments");
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.m_44865_(map, (ItemStack)copy);
        copy.m_41742_(0);
        if (copy.m_41720_() == Items.f_42690_ && map.size() == 0) {
            copy = new ItemStack((ItemLike)Items.f_42517_);
            if (stack.m_41788_()) {
                copy.m_41714_(stack.m_41786_());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            copy.m_41742_(AnvilMenu.m_39025_((int)copy.m_41610_()));
        }
        return copy;
    }

    public static ItemStack getFilledMap(Level level, BlockPos playerPos, TagKey<Structure> destination, MapDecoration.Type decorationType, String name) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = serverLevel.m_215011_(destination, playerPos, 100, true);
        if (pos == null) {
            return null;
        }
        ItemStack stack = MapItem.m_42886_((Level)serverLevel, (int)pos.m_123341_(), (int)pos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)stack);
        MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)decorationType);
        return stack.m_41714_((Component)Component.m_237115_((String)name));
    }
}

