/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core;

import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class UAConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> clericsBuyThrasherTeeth;
        public final ForgeConfigSpec.ConfigValue<Boolean> drownedSwimmingAnimation;
        public final ForgeConfigSpec.ConfigValue<Boolean> leatherworkersSellBedrolls;
        @ConfigKey(value="kelpy_ocean_ruins")
        public final ForgeConfigSpec.ConfigValue<Boolean> kelpyOceanRuins;
        public final ForgeConfigSpec.ConfigValue<Integer> deepOceanMobMaxHeight;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("items");
            builder.push("trades");
            this.clericsBuyThrasherTeeth = builder.define("Clerics buy thrasher teeth", true);
            this.leatherworkersSellBedrolls = builder.define("Leatherworkers sell bedrolls", true);
            builder.pop();
            builder.pop();
            builder.push("generation");
            builder.push("structures");
            this.kelpyOceanRuins = builder.comment("If Mossy Cobblestone and Stone Bricks are replaced with Kelpy Cobblestone and Stone Bricks in Ocean Ruins").define("Kelpy Ocean Ruins", true);
            builder.pop();
            builder.pop();
            builder.push("mobs");
            this.drownedSwimmingAnimation = builder.comment("Give Drowneds a swimming animation, like in bedrock edition").define("Drowned swimming animation", true);
            this.deepOceanMobMaxHeight = builder.comment("The max height that deep ocean mobs can spawn at").defineInRange("Deep ocean mob max height", 30, 0, 255);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> showUnobtainableDescription;
        public final ForgeConfigSpec.ConfigValue<Integer> daysTillRenderInsomniaOverlay;
        public final ForgeConfigSpec.ConfigValue<Boolean> replaceGlowSquidRenderer;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("misc");
            this.showUnobtainableDescription = builder.comment("If unimplemented items should show that they are unobtainable in their item description").define("Show unobtainable description", true);
            this.daysTillRenderInsomniaOverlay = builder.comment(new String[]{"The amount of days till the insomnia overlay is rendered", "Setting to 3 will make the overlay indicate phantom spawns", "Setting to 0 will disable the overlay"}).define("Days until insomnia overlay", (Object)0);
            this.replaceGlowSquidRenderer = builder.comment("If Glow Squids should use our Glow Squid Renderer.").define("Replace Glow Squid Renderer", true);
            builder.pop();
        }
    }
}

