/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.levelgen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.TreeUtil;
import com.teamabnormals.upgrade_aquatic.common.block.MulberryVineBlock;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class RiverTreeFeature
extends Feature<TreeConfiguration> {
    public RiverTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        int height = config.f_68190_.m_226153_(random);
        boolean flag = true;
        if (origin.m_123342_() > level.m_141937_() && origin.m_123342_() + height + 1 <= level.m_151558_()) {
            for (int j = origin.m_123342_(); j <= origin.m_123342_() + 1 + height; ++j) {
                int k = 1;
                if (j == origin.m_123342_()) {
                    k = 0;
                }
                if (j >= origin.m_123342_() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = origin.m_123341_() - k; l <= origin.m_123341_() + k && flag; ++l) {
                    for (int i1 = origin.m_123343_() - k; i1 <= origin.m_123343_() + k && flag; ++i1) {
                        if (j >= level.m_141937_() && j < level.m_151558_()) {
                            if (TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)blockpos$mutableblockpos.m_122178_(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtil.isValidGround((LevelAccessor)level, (BlockPos)origin.m_7495_(), (SaplingBlock)((SaplingBlock)UABlocks.RIVER_SAPLING.get())) && origin.m_123342_() < level.m_151558_() - height - 1) {
                HashSet logPositions = Sets.newHashSet();
                BiConsumer<BlockPos, BlockState> consumer = (pos, state) -> {
                    logPositions.add(pos.m_7949_());
                    TreeUtil.setForcedState((LevelWriter)level, (BlockPos)pos, (BlockState)state);
                };
                config.f_68190_.m_213934_((LevelSimulatedReader)level, consumer, random, height, origin, config);
                origin = new BlockPos(origin.m_123341_(), origin.m_123342_() + height - random.m_188503_(2), origin.m_123343_());
                this.createLeaves((LevelSimulatedRW)level, origin.m_7495_(), random, config, false);
                this.createLeaves((LevelSimulatedRW)level, origin, random, config, false);
                this.createLeaves((LevelSimulatedRW)level, origin.m_7494_(), random, config, true);
                this.placeLeavesAt((LevelSimulatedRW)level, origin.m_7494_(), random, config);
                this.placeLeavesAt((LevelSimulatedRW)level, origin.m_6630_(2), random, config);
                TreeUtil.updateLeaves((LevelAccessor)level, (Set)logPositions);
                return true;
            }
            return false;
        }
        return false;
    }

    private void createLeaves(LevelSimulatedRW worldIn, BlockPos newPos, RandomSource rand, TreeConfiguration config, boolean small) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (small) {
                    if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize || rand.m_188503_(3) == 0) continue;
                    this.placeLeavesAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeavesAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
                    continue;
                }
                if (rand.m_188503_(4) != 0) continue;
                this.placeLeavesAt(worldIn, newPos.m_7918_(k3, 0, j4), rand, config);
            }
        }
    }

    private void placeLeavesAt(LevelSimulatedRW world, BlockPos pos, RandomSource rand, TreeConfiguration config) {
        BlockState state;
        TreeUtil.placeLeafAt((LevelSimulatedRW)world, (BlockPos)pos, (RandomSource)rand, (TreeConfiguration)config);
        if (world.m_7433_(pos.m_7495_(), BlockBehaviour.BlockStateBase::m_60795_) && rand.m_188503_(3) == 0 && rand.m_188499_() && (state = (BlockState)((BlockState)((Block)UABlocks.MULBERRY_VINE.get()).m_49966_().m_61124_((Property)MulberryVineBlock.AGE, (Comparable)Integer.valueOf(4))).m_61124_((Property)MulberryVineBlock.DOUBLE, (Comparable)Boolean.valueOf(rand.m_188499_()))).m_60710_((LevelReader)world, pos.m_7495_())) {
            TreeUtil.setForcedState((LevelWriter)world, (BlockPos)pos.m_7495_(), (BlockState)state);
        }
    }
}

