/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.item;

import com.teamabnormals.blueprint.core.util.item.filling.TargetedItemCategoryFiller;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.jellyfish.AbstractJellyfish;
import com.teamabnormals.upgrade_aquatic.core.other.JellyfishRegistry;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class JellyfishBucketItem
extends BucketItem {
    private static final TargetedItemCategoryFiller FILLER = new TargetedItemCategoryFiller(() -> Items.f_42459_);

    public JellyfishBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public void m_142131_(@Nullable Player player, Level level, ItemStack stack, BlockPos pos) {
        if (level instanceof ServerLevel) {
            AbstractJellyfish jellyfish;
            CompoundTag compoundTag = stack.m_41783_();
            if (compoundTag != null && compoundTag.m_128441_("EntityType")) {
                EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(compoundTag.m_128461_("EntityType")));
                if (type == null) {
                    return;
                }
                Entity entity = type.m_20592_((ServerLevel)level, stack, null, pos, MobSpawnType.BUCKET, true, false);
                if (!(entity instanceof AbstractJellyfish)) {
                    return;
                }
                jellyfish = (AbstractJellyfish)entity;
            } else {
                List<JellyfishRegistry.JellyfishEntry<?>> jellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.COMMON);
                jellyfish = (AbstractJellyfish)jellies.get(new Random().nextInt(jellies.size())).jellyfish().get().m_20592_((ServerLevel)level, stack, null, pos, MobSpawnType.BUCKET, true, false);
                if (jellyfish == null) {
                    return;
                }
            }
            jellyfish.m_142278_(stack.m_41784_());
            jellyfish.m_27497_(true);
        }
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor levelAccessor, BlockPos pos) {
        levelAccessor.m_5594_(player, pos, (SoundEvent)UASoundEvents.ITEM_BUCKET_EMPTY_JELLYFISH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null && compoundTag.m_128441_("JellyfishDisplayTag")) {
            AbstractJellyfish.BucketDisplayInfo.appendHoverText(tooltip, compoundTag.m_128469_("JellyfishDisplayTag"));
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        FILLER.fillItem((Item)this, group, items);
    }
}

