/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.client.EntitySkinHelper;
import com.teamabnormals.upgrade_aquatic.client.model.NautilusModel;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.Nautilus;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NautilusRenderer
extends MobRenderer<Nautilus, NautilusModel<Nautilus>> {
    private static final EntitySkinHelper<Nautilus> SKIN_HELPER = EntitySkinHelper.create((String)"upgrade_aquatic", (String)"textures/entity/nautilus", (String)"nautilus", helper -> {
        helper.putSkins("smelly", new String[]{"smelly", "thefaceofgaming"});
        helper.putSkins("mca", new String[]{"abnormal", "abnautilus", "abnortilus", "mca"});
        helper.putSkins("five", new String[]{"five", "epic"});
        helper.putSkins("cell", new String[]{"neon membrane", "cell membrane", "cell"});
        helper.putSkins("tb", new String[]{"tb"});
        helper.putSkins("bagel", new String[]{"bagel", "shy guy", "legobagel"});
        helper.putSkins("sadcat", new String[]{"sadcat"});
        helper.putSkins("cameron", new String[]{"cameron", "cam", "cringe"});
        helper.putSkins("snake_block", new String[]{"snake", "snautilus", "snakeblock", "snake block"});
        helper.putSkins("snail", new String[]{"snail", "snail nautilus"});
    });

    public NautilusRenderer(EntityRendererProvider.Context context) {
        super(context, new NautilusModel(context.m_174023_(NautilusModel.LOCATION)), 0.25f);
    }

    public ResourceLocation getTextureLocation(Nautilus nautilus) {
        return SKIN_HELPER.getSkinForEntityOrElse((Entity)nautilus, new ResourceLocation("upgrade_aquatic", "textures/entity/nautilus/nautilus.png"));
    }

    protected void setupRotations(Nautilus nautilus, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)nautilus, matrixStack, ageInTicks, rotationYaw, partialTicks);
        float f = 0.3f * Mth.m_14031_((float)(0.6f * ageInTicks));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(f));
        if (!nautilus.m_20069_() && !nautilus.m_204029_(FluidTags.f_13131_)) {
            matrixStack.m_85837_((double)0.2f, (double)0.14f, 0.0);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        }
    }
}

