/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.tile.StorageTerminalBlockEntity;
import com.tom.storagemod.util.TickerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractStorageTerminalBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<TerminalPos> TERMINAL_POS = EnumProperty.m_61587_((String)"pos", TerminalPos.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE_N = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0);
    private static final VoxelShape SHAPE_S = Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E = Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_U = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_D = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public AbstractStorageTerminalBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(3.0f).m_60953_(s -> 6));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TERMINAL_POS, (Comparable)((Object)TerminalPos.CENTER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, TERMINAL_POS});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity_1 = world.m_7702_(pos);
        if (blockEntity_1 instanceof StorageTerminalBlockEntity) {
            StorageTerminalBlockEntity term = (StorageTerminalBlockEntity)blockEntity_1;
            if (term.canInteractWith(player)) {
                player.m_5893_((MenuProvider)term);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"chat.toms_storage.terminal_out_of_range"), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        TerminalPos pos = TerminalPos.CENTER;
        if (direction.m_122434_() == Direction.Axis.Y) {
            if (direction == Direction.UP) {
                pos = TerminalPos.UP;
            }
            if (direction == Direction.DOWN) {
                pos = TerminalPos.DOWN;
            }
            direction = context.m_8125_();
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(direction.m_122434_() == Direction.Axis.Y ? Direction.NORTH : direction))).m_61124_(TERMINAL_POS, (Comparable)((Object)pos))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((TerminalPos)((Object)state.m_61143_(TERMINAL_POS))) {
            case CENTER: {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    case NORTH: {
                        return SHAPE_N;
                    }
                    case SOUTH: {
                        return SHAPE_S;
                    }
                    case EAST: {
                        return SHAPE_E;
                    }
                    case WEST: {
                        return SHAPE_W;
                    }
                }
                break;
            }
            case UP: {
                return SHAPE_U;
            }
            case DOWN: {
                return SHAPE_D;
            }
        }
        return SHAPE_N;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    public static enum TerminalPos implements StringRepresentable
    {
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private String name;

        private TerminalPos(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

