/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.storagemod.gui.AbstractFilteredScreen;
import com.tom.storagemod.gui.GuiButton;
import com.tom.storagemod.gui.LevelEmitterMenu;
import com.tom.storagemod.gui.PlatformButton;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.util.IDataReceiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class LevelEmitterScreen
extends AbstractFilteredScreen<LevelEmitterMenu>
implements IDataReceiver {
    private static final ResourceLocation gui = new ResourceLocation("toms_storage", "textures/gui/level_emitter.png");
    private GuiButton lessThanBtn;
    private EditBox textF;
    private boolean lt;
    private int count = 1;
    private List<AmountBtn> amountBtns = new ArrayList<AmountBtn>();

    public LevelEmitterScreen(LevelEmitterMenu screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.amountBtns.forEach(AmountBtn::update);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.lessThanBtn.m_198029_()) {
            this.m_96597_(matrixStack, Arrays.stream(I18n.m_118938_((String)("tooltip.toms_storage.lvlEm_lt_" + this.lessThanBtn.state), (Object[])new Object[0]).split("\\\\")).map(Component::m_237113_).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)gui);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7856_() {
        this.m_169413_();
        this.amountBtns.clear();
        super.m_7856_();
        Objects.requireNonNull(this.f_96547_);
        this.textF = new EditBox(this.f_96547_, this.f_97735_ + 70, this.f_97736_ + 41, 89, 9, (Component)Component.m_237115_((String)"narrator.toms_storage.level_emitter_amount"));
        this.textF.m_94199_(100);
        this.textF.m_94182_(false);
        this.textF.m_94194_(true);
        this.textF.m_94202_(0xFFFFFF);
        this.textF.m_94144_(Integer.toString(this.count));
        this.textF.m_94151_(t -> {
            try {
                int c = Integer.parseInt(t);
                if (c >= 1) {
                    this.count = c;
                    this.send();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.m_142416_((GuiEventListener)this.textF);
        this.lessThanBtn = new GuiButton(this.f_97735_ - 18, this.f_97736_ + 5, 0, b -> {
            this.lt = !this.lt;
            this.lessThanBtn.state = this.lt ? 1 : 0;
            this.send();
        });
        this.lessThanBtn.texX = 176;
        this.lessThanBtn.texY = 0;
        this.lessThanBtn.texture = gui;
        this.lessThanBtn.state = this.lt ? 1 : 0;
        this.m_142416_((GuiEventListener)this.lessThanBtn);
        this.amountBtns.add(new AmountBtn(20, 0, 1, 1, 20));
        this.amountBtns.add(new AmountBtn(45, 0, 10, 16, 25));
        this.amountBtns.add(new AmountBtn(75, 0, 100, 32, 30));
        this.amountBtns.add(new AmountBtn(110, 0, 1000, 64, 35));
        this.amountBtns.add(new AmountBtn(20, 40, -1, -1, 20));
        this.amountBtns.add(new AmountBtn(45, 40, -10, -16, 25));
        this.amountBtns.add(new AmountBtn(75, 40, -100, -32, 30));
        this.amountBtns.add(new AmountBtn(110, 40, -1000, -64, 35));
    }

    @Override
    public void receive(CompoundTag tag) {
        this.count = tag.m_128451_("count");
        boolean lt = tag.m_128471_("lessThan");
        this.lessThanBtn.state = lt ? 1 : 0;
        this.lt = lt;
        this.textF.m_94144_(Integer.toString(this.count));
    }

    private void send() {
        CompoundTag mainTag = new CompoundTag();
        mainTag.m_128405_("count", this.count);
        mainTag.m_128379_("lessThan", this.lt);
        NetworkHandler.sendDataToServer(mainTag);
    }

    private class AmountBtn {
        private Button btn;
        private int v;
        private int sv;

        public AmountBtn(int x, int y, int v, int sv, int len) {
            this.btn = new PlatformButton(LevelEmitterScreen.this.f_97735_ + x, LevelEmitterScreen.this.f_97736_ + y + 16, len, 20, (Component)Component.m_237113_((String)((v > 0 ? "+" : "") + v)), this::evt);
            LevelEmitterScreen.this.m_142416_((GuiEventListener)this.btn);
            this.v = v;
            this.sv = sv;
        }

        private void evt(Button b) {
            LevelEmitterScreen.this.count = LevelEmitterScreen.this.count + (Screen.m_96638_() ? this.sv : this.v);
            if (LevelEmitterScreen.this.count < 1) {
                LevelEmitterScreen.this.count = 1;
            }
            LevelEmitterScreen.this.textF.m_94144_(Integer.toString(LevelEmitterScreen.this.count));
            LevelEmitterScreen.this.send();
        }

        private void update() {
            if (Screen.m_96638_()) {
                this.btn.m_93666_((Component)Component.m_237113_((String)((this.sv > 0 ? "+" : "") + this.sv)));
            } else {
                this.btn.m_93666_((Component)Component.m_237113_((String)((this.v > 0 ? "+" : "") + this.v)));
            }
        }
    }
}

