/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringOutline;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class QuiverItemGui
extends GuiElement {
    private final ItemStack itemStack;
    private final Minecraft mc;
    private final KeyframeAnimation showAnimation;
    private final GuiTexture backdrop;
    private Font fontRenderer;
    private GuiString count;
    private GuiString hoverLabel;

    public QuiverItemGui(int x, int y, ItemStack itemStack, int slot) {
        super(x, y, 23, 23);
        this.setAttachmentPoint(GuiAttachment.bottomRight);
        this.setAttachmentAnchor(GuiAttachment.bottomRight);
        this.itemStack = itemStack;
        this.mc = Minecraft.m_91087_();
        if (itemStack != null) {
            this.fontRenderer = null;
        }
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.f_91062_;
        }
        this.backdrop = new GuiTexture(0, 0, 23, 23, 32, 28, GuiTextures.toolbelt);
        this.addChild((GuiElement)this.backdrop);
        if (itemStack != null) {
            this.count = new GuiStringOutline(-3, 1, "" + itemStack.m_41613_());
            this.count.setAttachmentPoint(GuiAttachment.middleLeft);
            this.count.setAttachmentAnchor(GuiAttachment.middleRight);
            this.addChild((GuiElement)this.count);
            this.count.setVisible(false);
            this.hoverLabel = new GuiString(-5, 0, itemStack.m_41786_().getString());
            this.hoverLabel.setAttachmentPoint(GuiAttachment.middleRight);
            this.hoverLabel.setAttachmentAnchor(GuiAttachment.middleLeft);
            this.addChild((GuiElement)this.hoverLabel);
            this.hoverLabel.setVisible(false);
        }
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX((float)(x - 2), (float)x), new Applier.TranslateY((float)(y + 2), (float)y), new Applier.Opacity(0.0f, 1.0f)}).withDelay(slot * 80).onStop(finished -> this.count.setVisible(true));
    }

    protected void onShow() {
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        this.count.setVisible(false);
        this.hoverLabel.setVisible(false);
        return true;
    }

    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (this.opacity == 1.0f) {
            this.drawItemStack(this.itemStack, this.x + refX + 3, this.y + refY + 3);
        }
    }

    private void drawItemStack(ItemStack itemStack, int x, int y) {
        PoseStack renderSystemStack = RenderSystem.m_157191_();
        renderSystemStack.m_85836_();
        RenderSystem.m_69482_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.mc.m_91291_().m_115203_(itemStack, x, y);
        this.mc.m_91291_().m_115174_(this.fontRenderer, itemStack, x, y, "");
        RenderSystem.m_69465_();
        renderSystemStack.m_85849_();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    protected void onFocus() {
        this.backdrop.setColor(0xFFFFCC);
        this.hoverLabel.setVisible(true);
    }

    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
        this.hoverLabel.setVisible(false);
    }

    public void updateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus;
        boolean bl = gainFocus = (mouseX -= refX + this.x) + (mouseY -= refY + this.y) >= 12 && mouseX + mouseY <= 34 && mouseX - mouseY < 10 && mouseY - mouseX < 11;
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }
}

