/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.network.messages;

import java.util.function.BiConsumer;
import me.codexadrian.tempad.data.LocationData;
import me.codexadrian.tempad.network.handlers.IPacket;
import me.codexadrian.tempad.network.handlers.IPacketHandler;
import me.codexadrian.tempad.tempad.TempadItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record SummonTimedoorPacket(ResourceLocation dimensionKey, BlockPos pos, InteractionHand hand, int color) implements IPacket<SummonTimedoorPacket>
{
    public static Handler HANDLER = new Handler();
    public static final ResourceLocation ID = new ResourceLocation("tempad", "timedoor");

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public IPacketHandler<SummonTimedoorPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements IPacketHandler<SummonTimedoorPacket> {
        private Handler() {
        }

        @Override
        public void encode(SummonTimedoorPacket message, FriendlyByteBuf buffer) {
            buffer.m_130085_(message.dimensionKey);
            buffer.m_130064_(message.pos);
            buffer.m_130068_((Enum)message.hand);
            buffer.m_130130_(message.color);
        }

        @Override
        public SummonTimedoorPacket decode(FriendlyByteBuf buffer) {
            return new SummonTimedoorPacket(buffer.m_130281_(), buffer.m_130135_(), (InteractionHand)buffer.m_130066_(InteractionHand.class), buffer.m_130242_());
        }

        @Override
        public BiConsumer<MinecraftServer, Player> handle(SummonTimedoorPacket message) {
            return (server, player) -> {
                ItemStack itemInHand = player.m_21120_(message.hand());
                Item patt2151$temp = itemInHand.m_41720_();
                if (patt2151$temp instanceof TempadItem) {
                    TempadItem tempadItem = (TempadItem)patt2151$temp;
                    if (!player.m_150110_().f_35937_) {
                        tempadItem.getOption().onTimedoorOpen((Player)player, message.hand());
                    }
                }
                TempadItem.summonTimeDoor(new LocationData("", (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)message.dimensionKey), message.pos), player, message.color);
            };
        }
    }
}

