/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.forge;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeEnergyStorage
implements IEnergyStorage,
ICapabilityProvider {
    private final LazyOptional<IEnergyStorage> energyStorage = LazyOptional.of(() -> this);
    private final ItemStack stack;
    private final int maxEnergy;
    private final int maxExtract;
    private final int maxReceive;

    public ForgeEnergyStorage(ItemStack stack, int maxEnergy, int maxExtract, int maxReceive) {
        this.stack = stack;
        this.maxEnergy = maxEnergy;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public ForgeEnergyStorage(ItemStack stack, int maxEnergy) {
        this(stack, maxEnergy, maxEnergy, maxEnergy);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return capability == CapabilityEnergy.ENERGY ? this.energyStorage.cast() : LazyOptional.empty();
    }

    public void setEnergy(int energy) {
        this.stack.m_41784_().m_128405_("Energy", energy);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.maxEnergy - this.getEnergyStored(), Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.setEnergy(this.getEnergyStored() + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setEnergy(this.getEnergyStored() - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.stack.m_41783_() != null ? this.stack.m_41783_().m_128451_("Energy") : 0;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return this.getEnergyStored() > 0;
    }

    public boolean canReceive() {
        return this.getEnergyStored() < this.maxEnergy;
    }
}

