/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record UndoRedoPacket(boolean undo) {
    public static void encoder(UndoRedoPacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.undo);
    }

    public static UndoRedoPacket decoder(FriendlyByteBuf buff) {
        return new UndoRedoPacket(buff.readBoolean());
    }

    public static void handler(UndoRedoPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            ActionHistory history = ActionHistory.getOrCreateHistory((Player)sender);
            if (packet.undo) {
                history.undo(sender);
            } else {
                history.redo(sender);
            }
        });
        context.get().setPacketHandled(true);
    }
}

