/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure.jigsaw;

import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class JigsawRegistryHelper {
    public final String modid;
    public final String prefix;

    public JigsawRegistryHelper(String modid) {
        this(modid, "");
    }

    public JigsawRegistryHelper(String modid, String prefix) {
        this.modid = modid;
        this.prefix = prefix;
    }

    public JigsawRegistryHelper setModID(String modid) {
        return new JigsawRegistryHelper(modid, this.prefix);
    }

    public JigsawRegistryHelper setPrefix(String prefix) {
        return new JigsawRegistryHelper(this.modid, prefix);
    }

    public JigsawPoolBuilder builder() {
        return new JigsawPoolBuilder(this);
    }

    public Holder<StructureTemplatePool> register(String poolName, String fallback, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool, StructureTemplatePool.Projection projection) {
        return this.register(this.locatePiece(poolName), this.locatePiece(fallback), pool, projection);
    }

    public Holder<StructureTemplatePool> register(ResourceLocation poolName, ResourceLocation fallback, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool, StructureTemplatePool.Projection projection) {
        return Pools.m_211103_((StructureTemplatePool)new StructureTemplatePool(poolName, fallback, pool, projection));
    }

    public Holder<StructureTemplatePool> register(String poolName, String fallback, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool) {
        return this.register(poolName, fallback, pool, StructureTemplatePool.Projection.RIGID);
    }

    public Holder<StructureTemplatePool> register(ResourceLocation poolName, ResourceLocation fallback, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool) {
        return this.register(poolName, fallback, pool, StructureTemplatePool.Projection.RIGID);
    }

    public Holder<StructureTemplatePool> register(String poolName, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool, StructureTemplatePool.Projection projection) {
        return this.register(this.locatePiece(poolName), new ResourceLocation("empty"), pool, projection);
    }

    public Holder<StructureTemplatePool> register(ResourceLocation poolName, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool, StructureTemplatePool.Projection projection) {
        return this.register(poolName, new ResourceLocation("empty"), pool, projection);
    }

    public Holder<StructureTemplatePool> register(String poolName, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool) {
        return this.register(poolName, pool, StructureTemplatePool.Projection.RIGID);
    }

    public Holder<StructureTemplatePool> register(ResourceLocation poolName, List<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> pool) {
        return this.register(poolName, pool, StructureTemplatePool.Projection.RIGID);
    }

    protected ResourceLocation locatePiece(String key) {
        return new ResourceLocation(this.modid, this.prefix + key);
    }
}

