/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.registry.registrar.Registrar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class RegistrarHandler<T> {
    private static final Map<String, Map<ResourceKey<Registry<?>>, RegistrarHandler<?>>> HANDLERS = new HashMap();
    protected final ResourceKey<Registry<T>> registry;
    protected final String modID;
    private boolean registeredToBus = false;
    private final List<Registrar<?>> needsRegistered = new ArrayList();

    protected RegistrarHandler(ResourceKey<Registry<T>> registry, String modID) {
        this.registry = registry;
        this.modID = modID;
    }

    public static <T> RegistrarHandler<T> getOrCreate(ResourceKey<Registry<T>> registry, String modID) {
        return RegistrarHandler.getOrCreate(registry, modID, r -> new RegistrarHandler(r, modID));
    }

    public static BlockHandler getOrCreateBlocks(String modID) throws ClassCastException {
        RegistrarHandler handler = RegistrarHandler.getOrCreate(Registry.f_122901_, modID, r -> new BlockHandler(modID));
        if (handler instanceof BlockHandler) {
            return (BlockHandler)handler;
        }
        throw new ClassCastException("[Structure Gel] Cannot get a " + BlockHandler.class.getSimpleName() + " for " + modID + " because it already owns one as a " + handler.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> RegistrarHandler<T> getOrCreate(ResourceKey<Registry<T>> registry, String modID, Function<ResourceKey<Registry<?>>, RegistrarHandler<?>> handlerFactory) {
        Map<String, Map<ResourceKey<Registry<?>>, RegistrarHandler<?>>> map = HANDLERS;
        synchronized (map) {
            return HANDLERS.computeIfAbsent(modID, s -> new HashMap()).computeIfAbsent(registry, handlerFactory);
        }
    }

    public <V extends T> Registrar.Static<V> createStatic(String key, Supplier<V> value) {
        return this.createStatic(new ResourceLocation(this.modID, key), value);
    }

    public <V extends T> Registrar.Static<V> createStatic(ResourceLocation key, Supplier<V> value) {
        Registrar.Static<V> ret = Registrar.createStatic(this.registry, key, value);
        this.needsRegistered.add(ret);
        return ret;
    }

    public <V extends T> Registrar.Pointer<V> createPointer(String key, Supplier<V> value) {
        return this.createPointer(new ResourceLocation(this.modID, key), value);
    }

    public <V extends T> Registrar.Pointer<V> createPointer(ResourceLocation key, Supplier<V> value) {
        Registrar.Pointer<V> ret = Registrar.createPointer(this.registry, key, value);
        this.needsRegistered.add(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHandlers(String modID, IEventBus bus, RegistrarHandler<?> ... handlers) {
        RegistrarHandler<?>[] registrarHandlerArray = HANDLERS;
        synchronized (HANDLERS) {
            HANDLERS.getOrDefault(ModLoadingContext.get().getActiveNamespace(), Map.of()).values().forEach(h -> h.register(bus));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (RegistrarHandler<?> handler : handlers) {
                handler.register(bus);
            }
            return;
        }
    }

    public void register(IEventBus modBus) {
        if (!this.registeredToBus) {
            modBus.addListener(this::registerValues);
            this.registeredToBus = true;
        }
    }

    public void registerValues(RegisterEvent event) {
        if (this.registry.equals((Object)event.getRegistryKey())) {
            int s = this.needsRegistered.size();
            for (int i = 0; i < s; ++i) {
                Registrar<?> r = this.needsRegistered.get(i);
                r.register(event);
            }
            this.needsRegistered.clear();
        }
    }

    public static final class BlockHandler
    extends RegistrarHandler<Block> {
        protected BlockHandler(String modID) {
            super(Registry.f_122901_, modID);
        }

        public <V extends Block> Registrar.Pointer<V> createPointer(String key, Supplier<V> value, Item.Properties itemProperties) {
            return this.createPointer(key, value, itemProperties, BlockItem::new);
        }

        public <V extends Block> Registrar.Pointer<V> createPointer(ResourceLocation key, Supplier<V> value, Item.Properties itemProperties) {
            return this.createPointer(key, value, itemProperties, BlockItem::new);
        }

        public <V extends Block> Registrar.Pointer<V> createPointer(String key, Supplier<V> value, Item.Properties itemProperties, BiFunction<V, Item.Properties, BlockItem> blockItemFactory) {
            return this.createPointer(new ResourceLocation(this.modID, key), value, itemProperties, blockItemFactory);
        }

        public <V extends Block> Registrar.Pointer<V> createPointer(ResourceLocation key, Supplier<V> value, Item.Properties itemProperties, BiFunction<V, Item.Properties, BlockItem> blockItemFactory) {
            Registrar.Pointer ret = super.createPointer(key, value);
            BlockHandler.getOrCreate(Registry.f_122904_, this.modID).createPointer(key, () -> (BlockItem)blockItemFactory.apply((Block)ret.get(ForgeRegistries.BLOCKS), itemProperties));
            return ret;
        }

        public <V extends Block> Registrar.Static<V> createStatic(String key, Supplier<V> value, Item.Properties itemProperties) {
            return this.createStatic(key, value, itemProperties, BlockItem::new);
        }

        public <V extends Block> Registrar.Static<V> createStatic(ResourceLocation key, Supplier<V> value, Item.Properties itemProperties) {
            return this.createStatic(key, value, itemProperties, BlockItem::new);
        }

        public <V extends Block> Registrar.Static<V> createStatic(String key, Supplier<V> value, Item.Properties itemProperties, BiFunction<V, Item.Properties, BlockItem> blockItemFactory) {
            return this.createStatic(new ResourceLocation(this.modID, key), value, itemProperties, blockItemFactory);
        }

        public <V extends Block> Registrar.Static<V> createStatic(ResourceLocation key, Supplier<V> value, Item.Properties itemProperties, BiFunction<V, Item.Properties, BlockItem> blockItemFactory) {
            Registrar.Static ret = super.createStatic(key, value);
            BlockHandler.getOrCreate(Registry.f_122904_, this.modID).createStatic(key, () -> (BlockItem)blockItemFactory.apply((Block)ret.get(), itemProperties));
            return ret;
        }
    }
}

