/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.inventory;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.natamus.collective_common_forge.implementations.networking.api.Dispatcher;
import com.natamus.starterkit_common_forge.config.ConfigHandler;
import com.natamus.starterkit_common_forge.data.ConstantsClient;
import com.natamus.starterkit_common_forge.data.VariablesClient;
import com.natamus.starterkit_common_forge.functions.StarterClientFunctions;
import com.natamus.starterkit_common_forge.inventory.StarterKitEffectRenderingInventoryScreen;
import com.natamus.starterkit_common_forge.inventory.StarterKitInventoryMenu;
import com.natamus.starterkit_common_forge.networking.packets.ToServerSendKitChoicePacket;
import com.natamus.starterkit_common_forge.util.Util;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StarterKitInventoryScreen
extends StarterKitEffectRenderingInventoryScreen<StarterKitInventoryMenu> {
    private float xMouse;
    private float yMouse;
    private boolean widthTooNarrow;
    private boolean buttonClicked;

    public StarterKitInventoryScreen(Player player) {
        super(new StarterKitInventoryMenu(player), VariablesClient.cachedStarterKitInventory, (Component)Component.m_237113_((String)Util.formatKitName(VariablesClient.cachedStarterKitName)).m_130940_(ChatFormatting.BOLD));
        this.f_96541_ = Minecraft.m_91087_();
        if (player == null) {
            return;
        }
        Inventory kitInventory = VariablesClient.cachedStarterKitInventory;
        if (kitInventory == null) {
            return;
        }
        NonNullList itemList = kitInventory.f_35974_;
        NonNullList armourList = kitInventory.f_35975_;
        NonNullList offhandList = kitInventory.f_35976_;
        player.m_150109_().f_35977_ = 0;
        player.m_8061_(EquipmentSlot.HEAD, (ItemStack)armourList.get(3));
        player.m_8061_(EquipmentSlot.CHEST, (ItemStack)armourList.get(2));
        player.m_8061_(EquipmentSlot.LEGS, (ItemStack)armourList.get(1));
        player.m_8061_(EquipmentSlot.FEET, (ItemStack)armourList.get(0));
        player.m_8061_(EquipmentSlot.MAINHAND, (ItemStack)itemList.get(0));
        player.m_8061_(EquipmentSlot.OFFHAND, (ItemStack)offhandList.get(0));
        ConstantsClient.mc.f_91066_.f_92062_ = true;
    }

    @Override
    public void containerTick() {
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.setupButtons();
    }

    private void setupButtons() {
        Button previousKitButton = new Button(this.f_96543_ / 2 + 13, this.f_96544_ / 2 - 23, 30, 20, (Component)Component.m_237113_((String)" < "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.f_96541_.f_91074_, false));
        Button nextKitButton = new Button(this.f_96543_ / 2 + 47, this.f_96544_ / 2 - 23, 30, 20, (Component)Component.m_237113_((String)" > "), button -> StarterClientFunctions.cycleChooseKitScreen((Player)this.f_96541_.f_91074_, true));
        Button chooseKitButton = new Button(this.f_96543_ / 2 - 60, this.f_96544_ / 2 + 88, 120, 20, (Component)Component.m_237113_((String)"Choose Starter Kit"), button -> {
            StarterClientFunctions.clearPriorEquipmentCache();
            Dispatcher.sendToServer((Object)new ToServerSendKitChoicePacket(VariablesClient.cachedStarterKitName));
            ConstantsClient.mc.m_91152_(null);
        });
        this.m_142416_((GuiEventListener)previousKitButton);
        this.m_142416_((GuiEventListener)nextKitButton);
        this.m_142416_((GuiEventListener)chooseKitButton);
    }

    @Override
    protected void renderLabels(PoseStack poseStack, int i, int j) {
        String playerName = "";
        if (this.f_96541_.f_91074_ != null) {
            playerName = this.f_96541_.f_91074_.m_7755_().getString();
        }
        String headerString = ConfigHandler.chooseKitText.replace("%s", playerName);
        if (playerName.equals("")) {
            headerString = headerString.replace(", p", "P");
        }
        MutableComponent headerComponent = Component.m_237113_((String)headerString).m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
        int headerWidth = this.f_96547_.m_92852_((FormattedText)headerComponent);
        this.f_96547_.m_92889_(poseStack, (Component)headerComponent, -((float)(headerWidth - this.imageWidth) / 2.0f), -16.0f, 0);
        String fullKitName = Util.formatKitName(VariablesClient.cachedStarterKitName);
        Object kitName = fullKitName;
        while (this.f_96547_.m_92895_((String)kitName) > 88) {
            kitName = Util.removeLastChar((String)kitName);
        }
        if (!fullKitName.equalsIgnoreCase((String)kitName)) {
            kitName = (String)kitName + "...";
        }
        this.f_96547_.m_92883_(poseStack, (String)kitName, 79.0f, 7.0f, 0x404040);
        if (VariablesClient.cachedStarterKitDescriptions.containsKey(VariablesClient.cachedStarterKitName.toLowerCase())) {
            poseStack.m_85836_();
            String kitDescription = VariablesClient.cachedStarterKitDescriptions.get(VariablesClient.cachedStarterKitName.toLowerCase());
            MutableComponent descriptionComponent = Component.m_237113_((String)kitDescription);
            poseStack.m_85841_(0.66f, 0.66f, 0.66f);
            int y = 28;
            List descriptionLines = ComponentRenderUtils.m_94005_((FormattedText)descriptionComponent, (int)136, (Font)this.f_96541_.f_91062_);
            for (FormattedCharSequence line : descriptionLines) {
                int x = 120;
                if (y > 28) {
                    x -= 2;
                }
                if (y > 70 && descriptionLines.size() > 6) {
                    this.f_96547_.m_92883_(poseStack, "...", (float)(x + 132), (float)y, 0x404040);
                }
                this.f_96547_.m_92877_(poseStack, line, (float)x, (float)y, 0x404040);
                if ((y += 10) <= 80) continue;
                break;
            }
            poseStack.m_85849_();
        }
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int i, int j, float f) {
        super.m_6305_(poseStack, i, j, f);
        this.renderTooltip(poseStack, i, j);
        this.xMouse = i;
        this.yMouse = j;
    }

    @Override
    protected void renderBg(PoseStack poseStack, float f, int i, int j) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)INVENTORY_LOCATION);
        int k = this.leftPos;
        int l = this.topPos;
        this.m_93228_(poseStack, k, l, 0, 0, this.imageWidth, this.imageHeight);
        StarterKitInventoryScreen.renderEntityInInventory(k + 51, l + 75, 30, (float)(k + 51) - this.xMouse, (float)(l + 75 - 50) - this.yMouse, (LivingEntity)this.f_96541_.f_91074_);
    }

    public static void renderEntityInInventory(int i, int j, int k, float f, float g, LivingEntity livingEntity) {
        float h = (float)Math.atan(f / 40.0f);
        float l = (float)Math.atan(g / 40.0f);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)i, (double)j, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_85837_(0.0, 0.0, 1000.0);
        poseStack2.m_85841_((float)k, (float)k, (float)k);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion2 = Vector3f.f_122223_.m_122240_(l * 20.0f);
        quaternion.m_80148_(quaternion2);
        poseStack2.m_85845_(quaternion);
        float m = livingEntity.f_20883_;
        float n = livingEntity.m_146908_();
        float o = livingEntity.m_146909_();
        float p = livingEntity.f_20886_;
        float q = livingEntity.f_20885_;
        livingEntity.f_20883_ = 180.0f + h * 20.0f;
        livingEntity.m_146922_(180.0f + h * 40.0f);
        livingEntity.m_146926_(-l * 20.0f);
        livingEntity.f_20885_ = livingEntity.m_146908_();
        livingEntity.f_20886_ = livingEntity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.m_80157_();
        entityRenderDispatcher.m_114412_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack2, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        livingEntity.f_20883_ = m;
        livingEntity.m_146922_(n);
        livingEntity.m_146926_(o);
        livingEntity.f_20886_ = p;
        livingEntity.f_20885_ = q;
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    @Override
    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return !this.widthTooNarrow && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return !this.widthTooNarrow && super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected void slotClicked(@NotNull Slot slot, int slotId, int mouseButton, @NotNull ClickType type) {
    }

    public void recipesUpdated() {
    }
}

