/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_fabric.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.natamus.collective_common_fabric.implementations.networking.api.Dispatcher;
import com.natamus.starterkit_common_fabric.config.ConfigHandler;
import com.natamus.starterkit_common_fabric.data.ConstantsClient;
import com.natamus.starterkit_common_fabric.data.VariablesClient;
import com.natamus.starterkit_common_fabric.functions.StarterClientFunctions;
import com.natamus.starterkit_common_fabric.inventory.StarterKitEffectRenderingInventoryScreen;
import com.natamus.starterkit_common_fabric.inventory.StarterKitInventoryMenu;
import com.natamus.starterkit_common_fabric.networking.packets.ToServerSendKitChoicePacket;
import com.natamus.starterkit_common_fabric.util.Util;
import java.util.List;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_341;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;

public class StarterKitInventoryScreen
extends StarterKitEffectRenderingInventoryScreen<StarterKitInventoryMenu> {
    private float xMouse;
    private float yMouse;
    private boolean widthTooNarrow;
    private boolean buttonClicked;

    public StarterKitInventoryScreen(class_1657 player) {
        super(new StarterKitInventoryMenu(player), VariablesClient.cachedStarterKitInventory, (class_2561)class_2561.method_43470((String)Util.formatKitName(VariablesClient.cachedStarterKitName)).method_27692(class_124.field_1067));
        this.field_22787 = class_310.method_1551();
        if (player == null) {
            return;
        }
        class_1661 kitInventory = VariablesClient.cachedStarterKitInventory;
        if (kitInventory == null) {
            return;
        }
        class_2371 itemList = kitInventory.field_7547;
        class_2371 armourList = kitInventory.field_7548;
        class_2371 offhandList = kitInventory.field_7544;
        player.method_31548().field_7545 = 0;
        player.method_5673(class_1304.field_6169, (class_1799)armourList.get(3));
        player.method_5673(class_1304.field_6174, (class_1799)armourList.get(2));
        player.method_5673(class_1304.field_6172, (class_1799)armourList.get(1));
        player.method_5673(class_1304.field_6166, (class_1799)armourList.get(0));
        player.method_5673(class_1304.field_6173, (class_1799)itemList.get(0));
        player.method_5673(class_1304.field_6171, (class_1799)offhandList.get(0));
        ConstantsClient.mc.field_1690.field_1842 = true;
    }

    @Override
    public void containerTick() {
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.widthTooNarrow = this.field_22789 < 379;
        this.setupButtons();
    }

    private void setupButtons() {
        class_4185 previousKitButton = new class_4185(this.field_22789 / 2 + 13, this.field_22790 / 2 - 23, 30, 20, (class_2561)class_2561.method_43470((String)" < "), button -> StarterClientFunctions.cycleChooseKitScreen((class_1657)this.field_22787.field_1724, false));
        class_4185 nextKitButton = new class_4185(this.field_22789 / 2 + 47, this.field_22790 / 2 - 23, 30, 20, (class_2561)class_2561.method_43470((String)" > "), button -> StarterClientFunctions.cycleChooseKitScreen((class_1657)this.field_22787.field_1724, true));
        class_4185 chooseKitButton = new class_4185(this.field_22789 / 2 - 60, this.field_22790 / 2 + 88, 120, 20, (class_2561)class_2561.method_43470((String)"Choose Starter Kit"), button -> {
            StarterClientFunctions.clearPriorEquipmentCache();
            Dispatcher.sendToServer((Object)new ToServerSendKitChoicePacket(VariablesClient.cachedStarterKitName));
            ConstantsClient.mc.method_1507(null);
        });
        this.method_37063((class_364)previousKitButton);
        this.method_37063((class_364)nextKitButton);
        this.method_37063((class_364)chooseKitButton);
    }

    @Override
    protected void renderLabels(class_4587 poseStack, int i, int j) {
        String playerName = "";
        if (this.field_22787.field_1724 != null) {
            playerName = this.field_22787.field_1724.method_5477().getString();
        }
        String headerString = ConfigHandler.chooseKitText.replace("%s", playerName);
        if (playerName.equals("")) {
            headerString = headerString.replace(", p", "P");
        }
        class_5250 headerComponent = class_2561.method_43470((String)headerString).method_27692(class_124.field_1065).method_27692(class_124.field_1067);
        int headerWidth = this.field_22793.method_27525((class_5348)headerComponent);
        this.field_22793.method_30883(poseStack, (class_2561)headerComponent, -((float)(headerWidth - this.imageWidth) / 2.0f), -16.0f, 0);
        String fullKitName = Util.formatKitName(VariablesClient.cachedStarterKitName);
        Object kitName = fullKitName;
        while (this.field_22793.method_1727((String)kitName) > 88) {
            kitName = Util.removeLastChar((String)kitName);
        }
        if (!fullKitName.equalsIgnoreCase((String)kitName)) {
            kitName = (String)kitName + "...";
        }
        this.field_22793.method_1729(poseStack, (String)kitName, 79.0f, 7.0f, 0x404040);
        if (VariablesClient.cachedStarterKitDescriptions.containsKey(VariablesClient.cachedStarterKitName)) {
            poseStack.method_22903();
            String kitDescription = VariablesClient.cachedStarterKitDescriptions.get(VariablesClient.cachedStarterKitName);
            class_5250 descriptionComponent = class_2561.method_43470((String)kitDescription);
            poseStack.method_22905(0.66f, 0.66f, 0.66f);
            int y = 28;
            List descriptionLines = class_341.method_1850((class_5348)descriptionComponent, (int)136, (class_327)this.field_22787.field_1772);
            for (class_5481 line : descriptionLines) {
                int x = 120;
                if (y > 28) {
                    x -= 2;
                }
                if (y > 70 && descriptionLines.size() > 6) {
                    this.field_22793.method_1729(poseStack, "...", (float)(x + 132), (float)y, 0x404040);
                }
                this.field_22793.method_27528(poseStack, line, (float)x, (float)y, 0x404040);
                if ((y += 10) <= 80) continue;
                break;
            }
            poseStack.method_22909();
        }
    }

    @Override
    public void method_25394(@NotNull class_4587 poseStack, int i, int j, float f) {
        super.method_25394(poseStack, i, j, f);
        this.renderTooltip(poseStack, i, j);
        this.xMouse = i;
        this.yMouse = j;
    }

    @Override
    protected void renderBg(class_4587 poseStack, float f, int i, int j) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)INVENTORY_LOCATION);
        int k = this.leftPos;
        int l = this.topPos;
        this.method_25302(poseStack, k, l, 0, 0, this.imageWidth, this.imageHeight);
        StarterKitInventoryScreen.renderEntityInInventory(k + 51, l + 75, 30, (float)(k + 51) - this.xMouse, (float)(l + 75 - 50) - this.yMouse, (class_1309)this.field_22787.field_1724);
    }

    public static void renderEntityInInventory(int i, int j, int k, float f, float g, class_1309 livingEntity) {
        float h = (float)Math.atan(f / 40.0f);
        float l = (float)Math.atan(g / 40.0f);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_22904((double)i, (double)j, 1050.0);
        poseStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 poseStack2 = new class_4587();
        poseStack2.method_22904(0.0, 0.0, 1000.0);
        poseStack2.method_22905((float)k, (float)k, (float)k);
        class_1158 quaternion = class_1160.field_20707.method_23214(180.0f);
        class_1158 quaternion2 = class_1160.field_20703.method_23214(l * 20.0f);
        quaternion.method_4925(quaternion2);
        poseStack2.method_22907(quaternion);
        float m = livingEntity.field_6283;
        float n = livingEntity.method_36454();
        float o = livingEntity.method_36455();
        float p = livingEntity.field_6259;
        float q = livingEntity.field_6241;
        livingEntity.field_6283 = 180.0f + h * 20.0f;
        livingEntity.method_36456(180.0f + h * 40.0f);
        livingEntity.method_36457(-l * 20.0f);
        livingEntity.field_6241 = livingEntity.method_36454();
        livingEntity.field_6259 = livingEntity.method_36454();
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternion2.method_4926();
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack2, (class_4597)bufferSource, 0xF000F0));
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        livingEntity.field_6283 = m;
        livingEntity.method_36456(n);
        livingEntity.method_36457(o);
        livingEntity.field_6259 = p;
        livingEntity.field_6241 = q;
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    @Override
    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return !this.widthTooNarrow && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return !this.widthTooNarrow && super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.buttonClicked) {
            this.buttonClicked = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    protected void slotClicked(@NotNull class_1735 slot, int slotId, int mouseButton, @NotNull class_1713 type) {
    }

    public void recipesUpdated() {
    }
}

