/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_fabric.functions;

import com.natamus.collective_common_fabric.functions.GearFunctions;
import com.natamus.starterkit_common_fabric.data.Constants;
import com.natamus.starterkit_common_fabric.data.ConstantsClient;
import com.natamus.starterkit_common_fabric.data.Variables;
import com.natamus.starterkit_common_fabric.data.VariablesClient;
import com.natamus.starterkit_common_fabric.functions.StarterGearFunctions;
import com.natamus.starterkit_common_fabric.inventory.StarterKitInventoryScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_437;
import net.minecraft.class_746;

public class StarterClientFunctions {
    public static void showInitialChooseKitScreen() {
        StarterClientFunctions.showInitialChooseKitScreen((class_1657)ConstantsClient.mc.field_1724);
    }

    public static void showInitialChooseKitScreen(class_1657 player) {
        if (!StarterClientFunctions.cacheLocalPlayerEquipment()) {
            Constants.logger.warn("[Starter Kit] Unable to cache the local player's prior equipment.");
            return;
        }
        StarterClientFunctions.removeLocalPlayerEquipment();
        StarterClientFunctions.setCachedStarterKitInventory(player, 0);
        ConstantsClient.mc.method_1507((class_437)new StarterKitInventoryScreen(player));
    }

    public static void cycleChooseKitScreen(class_1657 player, boolean next) {
        if (player == null) {
            Constants.logger.warn("[Starter Kit] Unable to cycle the choose kit screen, player is null.");
            return;
        }
        List<String> activeKitNames = StarterGearFunctions.getActiveKitNames(VariablesClient.cachedStarterGearEntries);
        int kitIndex = 0;
        for (String activeKitName : activeKitNames) {
            if (activeKitName.equals(VariablesClient.cachedStarterKitName)) break;
            ++kitIndex;
        }
        kitIndex = next ? ++kitIndex : --kitIndex;
        if (kitIndex < 0) {
            kitIndex = activeKitNames.size() - 1;
        } else if (kitIndex >= activeKitNames.size()) {
            kitIndex = 0;
        }
        StarterClientFunctions.removeLocalPlayerEquipment();
        StarterClientFunctions.setCachedStarterKitInventory(player, kitIndex);
        ConstantsClient.mc.method_1507((class_437)new StarterKitInventoryScreen(player));
    }

    public static void setCachedStarterKitInventory(class_1657 player, int kitIndex) {
        class_1661 inventory = new class_1661(player);
        if (VariablesClient.cachedStarterGearEntries.size() == 0) {
            Constants.logger.warn("[Starter Kit] Unable to show the choose kit screen, starter gear entries are empty.");
            return;
        }
        if (kitIndex >= VariablesClient.cachedStarterGearEntries.size()) {
            Constants.logger.warn("[Starter Kit] Unable to show the choose kit screen, kit index higher than the cached starter gear entries.");
            return;
        }
        String kitName = StarterGearFunctions.getActiveKitNames(VariablesClient.cachedStarterGearEntries).get(kitIndex);
        String gearString = Variables.starterGearEntries.get(kitName);
        if (gearString == null) {
            Constants.logger.warn("[Starter Kit] Unable to show the choose kit screen, gearString is null from kit name '" + kitName + "' and kit index " + kitIndex + ".");
            return;
        }
        GearFunctions.setInventoryFromGearString((class_1661)inventory, (String)gearString);
        VariablesClient.cachedStarterKitName = kitName;
        VariablesClient.cachedStarterKitInventory = inventory;
        VariablesClient.cachedStarterKitEffects = GearFunctions.getEffectsFromGearString((class_1657)player, (String)gearString);
    }

    public static boolean cacheLocalPlayerEquipment() {
        class_746 localPlayer = ConstantsClient.mc.field_1724;
        if (localPlayer == null) {
            return false;
        }
        return StarterClientFunctions.cacheLocalPlayerEquipment((class_1657)localPlayer);
    }

    public static boolean cacheLocalPlayerEquipment(class_1657 player) {
        VariablesClient.priorPlayerEquipment = new HashMap();
        VariablesClient.priorPlayerHotbar = new ArrayList<class_1799>();
        player.method_31548().field_7545 = 0;
        for (class_1304 equipmentSlot : Constants.equipmentSlots) {
            VariablesClient.priorPlayerEquipment.put(equipmentSlot, player.method_6118(equipmentSlot).method_7972());
        }
        for (int i = 0; i < 9; ++i) {
            VariablesClient.priorPlayerHotbar.add(player.method_31548().method_5438(i).method_7972());
        }
        return true;
    }

    public static boolean removeLocalPlayerEquipment() {
        class_746 localPlayer = ConstantsClient.mc.field_1724;
        if (localPlayer == null) {
            return false;
        }
        return StarterClientFunctions.removeLocalPlayerEquipment((class_1657)localPlayer);
    }

    public static boolean removeLocalPlayerEquipment(class_1657 player) {
        class_1799 airStack = new class_1799((class_1935)class_1802.field_8162, 1);
        for (class_1304 equipmentSlot : Constants.equipmentSlots) {
            player.method_5673(equipmentSlot, airStack.method_7972());
        }
        for (int i = 0; i < 9; ++i) {
            player.method_31548().method_5447(i, airStack.method_7972());
        }
        return true;
    }

    public static boolean setPriorLocalPlayerEquipment() {
        class_746 localPlayer = ConstantsClient.mc.field_1724;
        if (localPlayer == null) {
            return false;
        }
        return StarterClientFunctions.setPriorLocalPlayerEquipment((class_1657)localPlayer);
    }

    public static boolean setPriorLocalPlayerEquipment(class_1657 player) {
        if (VariablesClient.priorPlayerEquipment == null || VariablesClient.priorPlayerHotbar == null) {
            return false;
        }
        player.method_31548().field_7545 = 0;
        for (class_1304 equipmentSlot : Constants.equipmentSlots) {
            class_1799 slotStack = VariablesClient.priorPlayerEquipment.get(equipmentSlot);
            if (slotStack == null) continue;
            player.method_5673(equipmentSlot, slotStack.method_7972());
        }
        for (int i = 0; i < 9; ++i) {
            player.method_31548().method_5447(i, VariablesClient.priorPlayerHotbar.get(i).method_7972());
        }
        ConstantsClient.mc.field_1690.field_1842 = false;
        return true;
    }

    public static void clearStarterKitClientCache() {
        VariablesClient.cachedStarterKitName = "";
        VariablesClient.cachedStarterKitInventory = null;
        VariablesClient.cachedStarterKitEffects = new ArrayList<class_1293>();
        StarterClientFunctions.clearPriorEquipmentCache();
    }

    public static void clearPriorEquipmentCache() {
        VariablesClient.priorPlayerEquipment = null;
        VariablesClient.priorPlayerHotbar = null;
        ConstantsClient.mc.field_1690.field_1842 = false;
    }

    public static void selectFirstSlot() {
        class_746 player = ConstantsClient.mc.field_1724;
        if (player != null) {
            player.method_31548().field_7545 = 0;
        }
    }
}

