/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.compat.rei.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.codexadrian.spirit.compat.jei.ingredients.EntityIngredient;
import me.codexadrian.spirit.compat.rei.SpiritPlugin;
import me.codexadrian.spirit.compat.rei.categories.PedestalRecipeCategory;
import me.codexadrian.spirit.recipe.PedestalRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PedestalDisplay
extends BasicDisplay {
    private final PedestalRecipe recipe;

    public PedestalDisplay(PedestalRecipe recipe) {
        super(PedestalDisplay.createEntityInput(recipe), List.of(PedestalDisplay.createEntityOutput(recipe), EntryIngredients.of((ItemLike)SpawnEggItem.m_43213_(recipe.entityOutput()))), Optional.ofNullable(recipe.m_6423_()));
        this.recipe = recipe;
    }

    public PedestalRecipe recipe() {
        return this.recipe;
    }

    private static EntryIngredient createEntityOutput(PedestalRecipe recipe) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Corrupted", true);
        return EntryIngredient.of((EntryStack)EntryStack.of(SpiritPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient(recipe.entityOutput(), -45.0f, Optional.of(nbt))));
    }

    private static List<EntryIngredient> createEntityInput(PedestalRecipe recipe) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Corrupted", true);
        List<EntryIngredient> list = recipe.entityInput().m_203614_().filter(Holder::m_203633_).map(Holder::m_203334_).map(type -> EntryIngredient.of((EntryStack)EntryStack.of(SpiritPlugin.ENTITY_INGREDIENT, (Object)new EntityIngredient((EntityType<?>)type, 45.0f, Optional.of(nbt))))).toList();
        ArrayList<EntryIngredient> finalList = new ArrayList<EntryIngredient>(list);
        finalList.addAll(EntryIngredients.ofIngredients(recipe.ingredients()));
        recipe.activationItem().ifPresent(item -> finalList.add(EntryIngredients.ofIngredient((Ingredient)item)));
        return finalList;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return PedestalRecipeCategory.RECIPE;
    }
}

