/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;

public abstract class StorageBlockBase
extends Block
implements IStorageBlock,
ISneakItemInteractionBlock,
EntityBlock {
    public static final BooleanProperty TICKING = BooleanProperty.m_61465_((String)"ticking");
    protected final Supplier<Integer> numberOfInventorySlotsSupplier;
    protected final Supplier<Integer> numberOfUpgradeSlotsSupplier;

    protected StorageBlockBase(BlockBehaviour.Properties properties, Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        super(properties);
        this.numberOfInventorySlotsSupplier = numberOfInventorySlotsSupplier;
        this.numberOfUpgradeSlotsSupplier = numberOfUpgradeSlotsSupplier;
    }

    public abstract StorageBlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typePassedIn, BlockEntityType<E> typeExpected, BlockEntityTicker<? super E> blockEntityTicker) {
        return typeExpected == typePassedIn ? blockEntityTicker : null;
    }

    protected static void renderUpgrades(Level level, RandomSource rand, BlockPos pos, Direction facing, RenderInfo renderInfo) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> StorageBlockBase.renderUpgrade(renderer, level, rand, pos, facing, type, data)));
    }

    private static Vector3f getMiddleFacePoint(BlockPos pos, Direction facing, Vector3f vector) {
        Vector3f point = vector.m_122281_();
        point.m_122272_(0.0f, 0.0f, 0.6f);
        point.m_122251_(Vector3f.f_122223_.m_122240_(-90.0f));
        point.m_122251_(facing.m_122406_());
        point.m_122272_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
        return point;
    }

    private static <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, Level level, RandomSource rand, BlockPos pos, Direction facing, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(level, rand, vector -> StorageBlockBase.getMiddleFacePoint(pos, facing, vector), renderData));
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(state, world, pos, entity);
        if (!world.f_46443_ && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, StorageBlockEntity.class).ifPresent(te -> this.tryToPickup(world, itemEntity, te.getStorageWrapper()));
        }
    }

    private void tryToPickup(Level world, ItemEntity itemEntity, IStorageWrapper w) {
        ItemStack remainingStack = itemEntity.m_32055_().m_41777_();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)world, (UpgradeHandler)w.getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.m_41613_() < itemEntity.m_32055_().m_41613_()) {
            itemEntity.m_32045_(remainingStack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return !level.f_46443_ && Boolean.TRUE.equals(state.m_61143_((Property)TICKING)) ? StorageBlockBase.createTickerHelper(blockEntityType, this.getBlockEntityType(), (l, blockPos, blockState, storageBlockEntity) -> StorageBlockEntity.serverTick(l, blockPos, storageBlockEntity)) : null;
    }

    protected abstract BlockEntityType<? extends StorageBlockEntity> getBlockEntityType();

    @Override
    public int getNumberOfInventorySlots() {
        return this.numberOfInventorySlotsSupplier.get();
    }

    @Override
    public int getNumberOfUpgradeSlots() {
        return this.numberOfUpgradeSlotsSupplier.get();
    }

    @Override
    public void setTicking(Level level, BlockPos pos, BlockState currentState, boolean ticking) {
        level.m_46597_(pos, (BlockState)currentState.m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(ticking)));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> InventoryHelper.getAnalogOutputSignal((ITrackedContentsItemHandler)be.getStorageWrapper().getInventoryForInputOutput())).orElse(0);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(b -> {
                b.removeFromController();
                if (b.shouldDropContents()) {
                    b.dropContents();
                }
                level.m_46717_(pos, (Block)this);
            });
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        WorldHelper.getBlockEntity((BlockGetter)pLevel, (BlockPos)pPos, StorageBlockEntity.class).ifPresent(IControllableStorage::removeFromController);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(be -> {
            RenderInfo renderInfo = be.getStorageWrapper().getRenderInfo();
            StorageBlockBase.renderUpgrades(level, rand, pos, this.getFacing(state), renderInfo);
        });
    }

    public VerticalFacing getVerticalFacing(BlockState state) {
        Direction facing = this.getFacing(state);
        if (facing == Direction.UP) {
            return VerticalFacing.UP;
        }
        if (facing == Direction.DOWN) {
            return VerticalFacing.DOWN;
        }
        return VerticalFacing.NO;
    }

    public Direction getHorizontalDirection(BlockState state) {
        Direction facing = this.getFacing(state);
        if (facing == Direction.UP) {
            return Direction.NORTH;
        }
        if (facing == Direction.DOWN) {
            return Direction.SOUTH;
        }
        return facing;
    }

    public abstract Direction getFacing(BlockState var1);

    public int getDisplayItemsCount(List<RenderInfo.DisplayItem> displayItems) {
        return displayItems.size();
    }

    public boolean hasFixedIndexDisplayItems() {
        return false;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(be -> be.onNeighborChange(neighbor));
    }

    protected boolean tryAddUpgrade(Player player, InteractionHand hand, StorageBlockEntity b, ItemStack itemInHand, Direction facing, BlockHitResult hitResult) {
        if (player.m_9236_().f_46443_) {
            return true;
        }
        if (hitResult.m_82434_() != facing) {
            return false;
        }
        return this.tryAddSingleUpgrade(player, hand, b, itemInHand);
    }

    public boolean tryAddSingleUpgrade(Player player, InteractionHand hand, StorageBlockEntity b, ItemStack itemInHand) {
        UpgradeItemBase upgradeItem;
        Item item = itemInHand.m_41720_();
        if (item instanceof UpgradeItemBase && RegistryHelper.getRegistryName((IForgeRegistry)ForgeRegistries.ITEMS, (Object)(upgradeItem = (UpgradeItemBase)item)).map(r -> r.m_135827_().equals("sophisticatedstorage")).orElse(false).booleanValue()) {
            UpgradeHandler upgradeHandler = b.getStorageWrapper().getUpgradeHandler();
            if (upgradeItem.canAddUpgradeTo((IStorageWrapper)b.getStorageWrapper(), itemInHand, true, b.m_58904_().m_5776_()).isSuccessful() && InventoryHelper.insertIntoInventory((ItemStack)itemInHand, (IItemHandler)upgradeHandler, (boolean)true).m_41613_() != itemInHand.m_41613_()) {
                InventoryHelper.insertIntoInventory((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemInHand, (int)1), (IItemHandler)upgradeHandler, (boolean)false);
                itemInHand.m_41774_(1);
                if (itemInHand.m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean trySneakItemInteraction(Player player, InteractionHand hand, BlockState state, Level level, BlockPos pos, BlockHitResult hitVec, ItemStack itemInHand) {
        if (level.m_5776_() || hitVec.m_82434_() != this.getFacing(state)) {
            return false;
        }
        return this.tryFillUpgrades(player, hand, level, pos, itemInHand);
    }

    public boolean tryFillUpgrades(Player player, InteractionHand hand, Level level, BlockPos pos, ItemStack itemInHand) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(b -> {
            boolean result = false;
            while (!itemInHand.m_41619_() && this.tryAddSingleUpgrade(player, hand, (StorageBlockEntity)b, itemInHand)) {
                result = true;
            }
            return result;
        }).orElse(false);
    }
}

