/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.Iterator;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;

public class UUIDDeduplicator {
    private UUIDDeduplicator() {
    }

    public static void checkForDuplicateBackpacksAndRemoveTheirUUID(Player player, UUID backpackUuid, ItemStack backpack) {
        PlayerInventoryProvider.get().runOnBackpacks(player, (otherBackpack, inventoryHandlerName, identifier, slot) -> {
            if (otherBackpack != backpack) {
                otherBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> wrapper.getContentsUuid().ifPresent(uuid -> {
                    if (uuid.equals(backpackUuid)) {
                        wrapper.removeContentsUUIDTag();
                        wrapper.onContentsNbtUpdated();
                    }
                }));
            }
            return false;
        });
    }

    public static void dedupeBackpackItemEntityInArea(ItemEntity newBackpackItemEntity) {
        newBackpackItemEntity.m_32055_().getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(newBackpackWrapper -> newBackpackWrapper.getContentsUuid().ifPresent(backpackId -> UUIDDeduplicator.dedupeBackpackItemEntityInArea(newBackpackWrapper, newBackpackItemEntity, backpackId)));
    }

    private static void dedupeBackpackItemEntityInArea(IBackpackWrapper newBackpackWrapper, ItemEntity newBackpackItemEntity, UUID backpackId) {
        ItemEntity entity;
        Iterator iterator = newBackpackItemEntity.f_19853_.m_6443_(ItemEntity.class, newBackpackItemEntity.m_20191_().m_82400_(10.0), Entity::m_6084_).iterator();
        while (iterator.hasNext() && !UUIDDeduplicator.checkEntityBackpackIdMatchAndRemoveIfItDoes(newBackpackWrapper, backpackId, entity = (ItemEntity)iterator.next())) {
        }
    }

    private static boolean checkEntityBackpackIdMatchAndRemoveIfItDoes(IBackpackWrapper newBackpackWrapper, UUID newBackpackId, ItemEntity entity) {
        return entity.m_32055_().getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).resolve().flatMap(IStorageWrapper::getContentsUuid).map(backpackId -> {
            if (backpackId.equals(newBackpackId)) {
                newBackpackWrapper.removeContentsUUIDTag();
                newBackpackWrapper.onContentsNbtUpdated();
                return true;
            }
            return false;
        }).orElse(false);
    }
}

