/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.EmptyEnergyStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class BackpackBlockEntity
extends BlockEntity
implements IControllableStorage {
    @Nullable
    private BlockPos controllerPos = null;
    private IBackpackWrapper backpackWrapper = IBackpackWrapper.Noop.INSTANCE;
    private boolean updateBlockRender = true;
    private boolean chunkBeingUnloaded = false;
    @Nullable
    private LazyOptional<IItemHandler> itemHandlerCap;
    @Nullable
    private LazyOptional<IFluidHandler> fluidHandlerCap;
    @Nullable
    private LazyOptional<IEnergyStorage> energyStorageCap;

    public BackpackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.BACKPACK_TILE_TYPE.get(), pos, state);
    }

    public void setBackpack(ItemStack backpack) {
        this.backpackWrapper = (IBackpackWrapper)backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)IBackpackWrapper.Noop.INSTANCE);
        this.backpackWrapper.setSaveHandler(() -> {
            this.m_6596_();
            this.updateBlockRender = false;
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        });
        this.backpackWrapper.setInventorySlotChangeHandler(() -> ((BackpackBlockEntity)this).m_6596_());
        this.backpackWrapper.setUpgradeCachesInvalidatedHandler(this::invalidateBackpackCaps);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setBackpackFromNbt(tag);
        this.loadControllerPos(tag);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.removeControllerPos();
            this.tryToAddToController();
        }
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public void onLoad() {
        super.onLoad();
        this.registerWithControllerOnLoad();
    }

    private void setBackpackFromNbt(CompoundTag nbt) {
        this.setBackpack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("backpackData")));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeBackpack(tag);
        this.saveControllerPos(tag);
    }

    private void writeBackpack(CompoundTag ret) {
        ItemStack backpackCopy = this.backpackWrapper.getBackpack().m_41777_();
        backpackCopy.m_41751_(backpackCopy.m_41720_().getShareTag(backpackCopy));
        ret.m_128365_("backpackData", (Tag)backpackCopy.m_41739_(new CompoundTag()));
    }

    public CompoundTag m_5995_() {
        CompoundTag ret = super.m_5995_();
        this.writeBackpack(ret);
        ret.m_128379_("updateBlockRender", this.updateBlockRender);
        this.updateBlockRender = true;
        return ret;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag == null) {
            return;
        }
        this.setBackpackFromNbt(tag);
        if (tag.m_128471_("updateBlockRender")) {
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        }
    }

    public IBackpackWrapper getBackpackWrapper() {
        return this.backpackWrapper;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (side != null && this.f_58857_ != null && Config.SERVER.noConnectionBlocks.isBlockConnectionDisallowed(this.f_58857_.m_8055_(this.m_58899_().m_121945_(side)).m_60734_())) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = LazyOptional.of(() -> new CachedFailedInsertInventoryHandler(() -> this.getBackpackWrapper().getInventoryForInputOutput(), () -> this.f_58857_ != null ? this.f_58857_.m_46467_() : 0L));
            }
            return this.itemHandlerCap.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (this.fluidHandlerCap == null) {
                this.fluidHandlerCap = LazyOptional.of(() -> this.getBackpackWrapper().getFluidHandler().map(IFluidHandler.class::cast).orElse((IFluidHandler)EmptyFluidHandler.INSTANCE));
            }
            return this.fluidHandlerCap.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            if (this.energyStorageCap == null) {
                this.energyStorageCap = LazyOptional.of(() -> this.getBackpackWrapper().getEnergyStorage().map(IEnergyStorage.class::cast).orElse(EmptyEnergyStorage.INSTANCE));
            }
            return this.energyStorageCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.invalidateBackpackCaps();
    }

    private void invalidateBackpackCaps() {
        if (this.itemHandlerCap != null) {
            LazyOptional<IItemHandler> tempItemHandlerCap = this.itemHandlerCap;
            this.itemHandlerCap = null;
            tempItemHandlerCap.invalidate();
        }
        if (this.fluidHandlerCap != null) {
            LazyOptional<IFluidHandler> tempFluidHandlerCap = this.fluidHandlerCap;
            this.fluidHandlerCap = null;
            tempFluidHandlerCap.invalidate();
        }
        if (this.energyStorageCap != null) {
            LazyOptional<IEnergyStorage> tempEnergyStorageCap = this.energyStorageCap;
            this.energyStorageCap = null;
            tempEnergyStorageCap.invalidate();
        }
    }

    public void refreshRenderState() {
        BlockState state = this.m_58900_();
        state = (BlockState)state.m_61124_((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(false));
        state = (BlockState)state.m_61124_((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(false));
        RenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        for (TankPosition pos : renderInfo.getTankRenderInfos().keySet()) {
            if (pos == TankPosition.LEFT) {
                state = (BlockState)state.m_61124_((Property)BackpackBlock.LEFT_TANK, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (pos != TankPosition.RIGHT) continue;
            state = (BlockState)state.m_61124_((Property)BackpackBlock.RIGHT_TANK, (Comparable)Boolean.valueOf(true));
        }
        state = (BlockState)state.m_61124_((Property)BackpackBlock.BATTERY, (Comparable)Boolean.valueOf(renderInfo.getBatteryRenderInfo().isPresent()));
        Level l = Objects.requireNonNull(this.f_58857_);
        l.m_46597_(this.f_58858_, state);
        l.m_46672_(this.f_58858_, state.m_60734_());
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public static void serverTick(Level level, BlockPos blockPos, BackpackBlockEntity backpackBlockEntity) {
        if (level.f_46443_) {
            return;
        }
        backpackBlockEntity.backpackWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }

    public IStorageWrapper getStorageWrapper() {
        return this.backpackWrapper;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.m_6596_();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
    }

    public BlockPos getStorageBlockPos() {
        return this.m_58899_();
    }

    public Level getStorageBlockLevel() {
        return Objects.requireNonNull(this.m_58904_());
    }

    public boolean canConnectStorages() {
        return false;
    }

    public void unregisterController() {
        super.unregisterController();
        this.backpackWrapper.unregisterOnSlotsChangeListener();
        this.backpackWrapper.unregisterOnInventoryHandlerRefreshListener();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        super.registerController(controllerBlockEntity);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.backpackWrapper.registerOnSlotsChangeListener(arg_0 -> ((BackpackBlockEntity)this).changeSlots(arg_0));
            this.backpackWrapper.registerOnInventoryHandlerRefreshListener(() -> ((BackpackBlockEntity)this).registerInventoryStackListeners());
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void m_7651_() {
        if (!this.chunkBeingUnloaded && this.f_58857_ != null) {
            this.removeFromController();
        }
        super.m_7651_();
    }
}

