/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.smarterfarmers.goal.EatFoodGoal;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmarterFarmers {
    public static final String MOD_ID = "smarterfarmers";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final TagKey<Block> SPECIAL_HARVESTABLE = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("smarterfarmers", "harvestable_plant"));
    public static final TagKey<Block> NO_REPLANT = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("smarterfarmers", "harvestable_plant_no_replant"));
    public static final TagKey<Block> VALID_FARMLAND = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("smarterfarmers", "farmer_plantable_on"));
    public static final TagKey<Item> MEAT = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("forge", "food/meat"));

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void commonInit() {
        MoonlightEventsHelper.addListener(SmarterFarmers::onVillagerBrainInitialize, IVillagerBrainEvent.class);
    }

    public static void setup() {
        try {
            HashMap<Item, Integer> newMap = new HashMap<Item, Integer>(Villager.f_35369_);
            for (Item i : Registry.f_122827_) {
                if (!i.m_41472_() || i.m_41460_(new ItemStack((ItemLike)i)) != Rarity.COMMON || i.m_204114_().m_203656_(MEAT) || i instanceof BowlFoodItem || i instanceof HoneyBottleItem) continue;
                newMap.put(i, (int)Math.max(1.0f, (float)(i.m_41473_().m_38744_() * 2) / 3.0f));
            }
            Villager.f_35369_ = newMap;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add custom foods to villagers");
        }
    }

    public static void onVillagerBrainInitialize(IVillagerBrainEvent event) {
        if (!event.getVillager().m_6162_()) {
            event.addTaskToActivity(Activity.f_37983_, Pair.of((Object)7, (Object)((Object)new EatFoodGoal(100, 140))));
        }
    }

    public static void spawnEatingParticles(AbstractVillager villager) {
        Vec3 pos = new Vec3(0.0, 0.0, 0.4);
        pos = pos.m_82524_(-villager.f_20883_ * ((float)Math.PI / 180));
        pos = pos.m_82520_(villager.m_20185_(), villager.m_20188_(), villager.m_20189_());
        ItemStack stack = villager.m_21205_();
        Level level = villager.m_9236_();
        level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_ + (double)Mth.m_216283_((RandomSource)level.f_46441_, (float)-0.05f, (float)0.05f), pos.f_82480_ - 0.4 + (double)Mth.m_216283_((RandomSource)level.f_46441_, (float)-0.05f, (float)0.05f), pos.f_82481_ + (double)Mth.m_216283_((RandomSource)level.f_46441_, (float)-0.05f, (float)0.05f), 0.03, 0.05, 0.03);
    }
}

