/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.servercountryflags.common.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.khajiitos.servercountryflags.common.ServerCountryFlags;
import me.khajiitos.servercountryflags.common.config.Config;
import me.khajiitos.servercountryflags.common.util.APIResponse;
import me.khajiitos.servercountryflags.common.util.LocationInfo;
import me.khajiitos.servercountryflags.common.util.NetworkChangeDetector;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ServerMapScreen
extends Screen {
    public static final ResourceLocation MAP_TEXTURE = new ResourceLocation("servercountryflags", "textures/misc/map.jpg");
    public static final ResourceLocation POINT_TEXTURE = new ResourceLocation("servercountryflags", "textures/misc/point.png");
    public static final ResourceLocation POINT_HOVERED_TEXTURE = new ResourceLocation("servercountryflags", "textures/misc/point_hovered.png");
    public static final ResourceLocation POINT_HOME_TEXTURE = new ResourceLocation("servercountryflags", "textures/misc/point_home.png");
    public static final double MAP_TEXTURE_ASPECT = 2.0;
    public static final double POINT_TEXTURE_ASPECT = 0.6976127320954907;
    public static final double ZOOM_STRENGTH = 0.1;
    private int mapStartX;
    private int mapStartY;
    private int mapWidth;
    private int mapHeight;
    private final Screen parent;
    private final ArrayList<Point> points = new ArrayList();
    private double zoomedAreaStartX = 0.0;
    private double zoomedAreaStartY = 0.0;
    private double zoomedAreaWidth = 1.0;
    private double zoomedAreaHeight = 1.0;
    private boolean movingMap = false;
    private double movingMapLastX = -1.0;
    private double movingMapLastY = -1.0;

    public ServerMapScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"servercountryflags.servermap.title"));
        this.parent = parent;
        if (Config.cfg.showHomeOnMap && ServerCountryFlags.localLocation != null) {
            this.addPoint(null, ServerCountryFlags.localLocation);
        }
        for (Map.Entry<String, APIResponse> entry : ServerCountryFlags.servers.entrySet()) {
            if (entry.getValue().locationInfo() == null) continue;
            this.addPoint(entry.getKey(), entry.getValue().locationInfo());
        }
    }

    public Point getPoint(double lon, double lat) {
        for (Point point : this.points) {
            if (point.locationInfo.longitude != lon || point.locationInfo.latitude != lat) continue;
            return point;
        }
        return null;
    }

    public double clampDouble(double value, double min, double max) {
        if (value > max) {
            value = max;
        } else if (value < min) {
            value = min;
        }
        return value;
    }

    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        if (this.movingMap) {
            double deltaX = (this.movingMapLastX - mouseX) / (double)this.mapWidth * this.zoomedAreaWidth;
            double deltaY = (this.movingMapLastY - mouseY) / (double)this.mapHeight * this.zoomedAreaHeight;
            this.movingMapLastX = mouseX;
            this.movingMapLastY = mouseY;
            this.zoomedAreaStartX = this.clampDouble(this.zoomedAreaStartX + deltaX, 0.0, 1.0 - this.zoomedAreaWidth);
            this.zoomedAreaStartY = this.clampDouble(this.zoomedAreaStartY + deltaY, 0.0, 1.0 - this.zoomedAreaHeight);
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.movingMap = false;
            this.movingMapLastX = -1.0;
            this.movingMapLastY = -1.0;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.mapStartX && mouseX <= (double)(this.mapStartX + this.mapWidth) && mouseY >= (double)this.mapStartY && mouseY <= (double)(this.mapStartY + this.mapHeight)) {
            this.movingMap = true;
            this.movingMapLastX = mouseX;
            this.movingMapLastY = mouseY;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (mouseX >= (double)this.mapStartX && mouseX <= (double)(this.mapStartX + this.mapWidth) && mouseY >= (double)this.mapStartY && mouseY <= (double)(this.mapStartY + this.mapHeight)) {
            double oldWidth = this.zoomedAreaWidth;
            double oldHeight = this.zoomedAreaHeight;
            this.zoomedAreaWidth = this.clampDouble(this.zoomedAreaWidth - amount * 0.1, 0.05, 1.0);
            this.zoomedAreaHeight = this.clampDouble(this.zoomedAreaHeight - amount * 0.1, 0.05, 1.0);
            double widthDelta = oldWidth - this.zoomedAreaWidth;
            double heightDelta = oldHeight - this.zoomedAreaHeight;
            this.zoomedAreaStartX = this.clampDouble(this.zoomedAreaStartX + (mouseX - (double)this.mapStartX) / (double)this.mapWidth * widthDelta, 0.0, 1.0 - this.zoomedAreaWidth);
            this.zoomedAreaStartY = this.clampDouble(this.zoomedAreaStartY + (mouseY - (double)this.mapStartY) / (double)this.mapHeight * heightDelta, 0.0, 1.0 - this.zoomedAreaHeight);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    private void addPoint(String name, LocationInfo locationInfo) {
        Point point = this.getPoint(locationInfo.longitude, locationInfo.latitude);
        if (point != null) {
            point.addServer(name);
        } else {
            this.points.add(new Point(name, locationInfo));
        }
    }

    public void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 105, this.f_96544_ - 26, 100, 20, (Component)Component.m_237115_((String)"selectServer.refresh"), button -> {
            this.m_169413_();
            this.m_7856_();
            if (ServerCountryFlags.serverList == null) {
                return;
            }
            if (Config.cfg.reloadOnRefresh) {
                this.points.clear();
                ServerCountryFlags.servers.clear();
                ServerCountryFlags.localLocation = null;
            }
            if (ServerCountryFlags.localLocation == null || NetworkChangeDetector.check()) {
                ServerCountryFlags.updateLocalLocationInfo();
            }
            for (int i = 0; i < ServerCountryFlags.serverList.m_105445_(); ++i) {
                if (ServerCountryFlags.servers.containsKey(ServerCountryFlags.serverList.m_105432_((int)i).f_105363_)) continue;
                ServerCountryFlags.updateServerLocationInfo(ServerCountryFlags.serverList.m_105432_((int)i).f_105363_);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 26, 100, 20, (Component)Component.m_237115_((String)"gui.back"), button -> Minecraft.m_91087_().m_91152_(this.parent)));
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, delta);
        ServerMapScreen.m_168749_((PoseStack)poseStack, (Font)this.f_96547_, (FormattedCharSequence)this.m_96636_().m_7532_(), (int)(this.f_96543_ / 2), (int)12, (int)-1);
        ServerMapScreen.m_93172_((PoseStack)poseStack, (int)0, (int)32, (int)this.f_96543_, (int)(this.f_96544_ - 32), (int)-1442840576);
        this.mapHeight = this.f_96544_ - 64;
        this.mapWidth = (int)((double)this.mapHeight * 2.0);
        if (this.mapWidth > this.f_96543_) {
            this.mapWidth = this.f_96543_;
            this.mapHeight = (int)((double)this.mapWidth / 2.0);
        }
        this.mapStartX = this.f_96543_ / 2 - this.mapWidth / 2;
        this.mapStartY = 32 + ((this.f_96544_ - 64) / 2 - this.mapHeight / 2);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MAP_TEXTURE);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
        ServerMapScreen.m_93160_((PoseStack)poseStack, (int)this.mapStartX, (int)this.mapStartY, (int)this.mapWidth, (int)this.mapHeight, (float)((float)((double)this.mapWidth * this.zoomedAreaStartX)), (float)((float)((double)this.mapHeight * this.zoomedAreaStartY)), (int)((int)((double)this.mapWidth * this.zoomedAreaWidth)), (int)((int)((double)this.mapHeight * this.zoomedAreaHeight)), (int)this.mapWidth, (int)this.mapHeight);
        Point hoveredPoint = null;
        int pointHeight = this.mapHeight / 20;
        int pointWidth = (int)((double)pointHeight * 0.6976127320954907);
        for (int i = this.points.size() - 1; i >= 0; --i) {
            Point point = this.points.get(i);
            Coordinates coords = this.latlonToPos(point.locationInfo.latitude, point.locationInfo.longitude, this.mapWidth, this.mapHeight);
            int pointStartX = this.mapStartX + coords.x - pointWidth / 2;
            int pointStartY = this.mapStartY + coords.y - pointHeight;
            if (coords.x < 0 || coords.x > this.mapWidth - pointWidth / 2 || coords.y < pointHeight || coords.y > this.mapHeight || mouseX < pointStartX || mouseX > pointStartX + pointWidth || mouseY < pointStartY || mouseY > pointStartY + pointHeight) continue;
            hoveredPoint = point;
            break;
        }
        for (Point point : this.points) {
            point.render(poseStack, hoveredPoint == point);
        }
        if (hoveredPoint != null) {
            this.m_96617_(poseStack, hoveredPoint.getTooltip(), mouseX, mouseY);
        }
        RenderSystem.m_69461_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private static boolean doesServerListHaveServer(String serverIp) {
        if (ServerCountryFlags.serverList == null) {
            return false;
        }
        return ServerCountryFlags.serverList.m_233845_(serverIp) != null;
    }

    public void m_86600_() {
        super.m_86600_();
        this.points.clear();
        if (ServerCountryFlags.localLocation != null) {
            this.addPoint(null, ServerCountryFlags.localLocation);
        }
        for (Map.Entry<String, APIResponse> entry : ServerCountryFlags.servers.entrySet()) {
            if (!ServerMapScreen.doesServerListHaveServer(entry.getKey()) || entry.getValue().locationInfo() == null) continue;
            this.addPoint(entry.getKey(), entry.getValue().locationInfo());
        }
    }

    private Coordinates latlonToPos(double lat, double lon, int width, int height) {
        int x = (int)((double)width * (((180.0 + lon) / 360.0 - this.zoomedAreaStartX) / this.zoomedAreaHeight));
        int y = (int)((double)height * (((90.0 - lat) / 180.0 - this.zoomedAreaStartY) / this.zoomedAreaWidth));
        return new Coordinates(x, y);
    }

    public class Point {
        LocationInfo locationInfo;
        List<String> servers = new ArrayList<String>();
        public boolean hasHome;

        public Point(String beginningName, LocationInfo beginningLocationInfo) {
            this.locationInfo = beginningLocationInfo;
            this.addServer(beginningName);
        }

        public void addServer(String name) {
            if (name == null) {
                this.hasHome = true;
            }
            this.servers.add(name);
        }

        public List<FormattedCharSequence> getTooltip() {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237113_((String)((String)(Config.cfg.showDistrict && !this.locationInfo.districtName.equals("") ? this.locationInfo.districtName + ", " : "") + this.locationInfo.cityName + ", " + this.locationInfo.countryName)).m_130940_(ChatFormatting.BOLD).m_7532_());
            list.add(Component.m_130674_(null).m_7532_());
            for (String server : this.servers) {
                if (server == null) {
                    list.add(Component.m_237115_((String)"servercountryflags.servermap.home").m_130940_(ChatFormatting.BOLD).m_7532_());
                    continue;
                }
                list.add(Component.m_237113_((String)server).m_7532_());
            }
            return list;
        }

        private void render(PoseStack poseStack, boolean hovered) {
            Coordinates coords = ServerMapScreen.this.latlonToPos(this.locationInfo.latitude, this.locationInfo.longitude, ServerMapScreen.this.mapWidth, ServerMapScreen.this.mapHeight);
            int pointHeight = ServerMapScreen.this.mapHeight / 20;
            int pointWidth = (int)((double)pointHeight * 0.6976127320954907);
            int pointStartX = ServerMapScreen.this.mapStartX + coords.x - pointWidth / 2;
            int pointStartY = ServerMapScreen.this.mapStartY + coords.y - pointHeight;
            if (coords.x < 0 || coords.x > ServerMapScreen.this.mapWidth - pointWidth / 2 || coords.y < pointHeight || coords.y > ServerMapScreen.this.mapHeight) {
                return;
            }
            ResourceLocation texture = POINT_TEXTURE;
            if (this.hasHome) {
                texture = POINT_HOME_TEXTURE;
            } else if (hovered) {
                texture = POINT_HOVERED_TEXTURE;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)pointStartX, (int)pointStartY, (float)0.0f, (float)0.0f, (int)pointWidth, (int)pointHeight, (int)pointWidth, (int)pointHeight);
        }
    }

    public static class Coordinates {
        public int x;
        public int y;

        public Coordinates(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

