/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.data.provider;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.advancement.HarvestSaltCrystalTrigger;
import io.github.mortuusars.salt.advancement.SaltEvaporationTrigger;
import io.github.mortuusars.salt.advancement.SaltedFoodConsumedTrigger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Advancements
extends AdvancementProvider {
    private final Path PATH;
    private ExistingFileHelper existingFileHelper;
    public static final Logger LOGGER = LogManager.getLogger();

    public Advancements(DataGenerator dataGenerator, ExistingFileHelper existingFileHelper) {
        super(dataGenerator);
        this.PATH = dataGenerator.m_123916_();
        this.existingFileHelper = existingFileHelper;
    }

    public void m_213708_(CachedOutput cache) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path = Advancements.getPath(this.PATH, advancement);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path, (Object)ioexception);
            }
        };
        new SaltAdvancements(this.existingFileHelper).accept(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public static class SaltAdvancements
    implements Consumer<Consumer<Advancement>> {
        private ExistingFileHelper existingFileHelper;

        public SaltAdvancements(ExistingFileHelper existingFileHelper) {
            this.existingFileHelper = existingFileHelper;
        }

        @Override
        public void accept(Consumer<Advancement> advancementConsumer) {
            Advancement taste_explosion = Advancement.Builder.m_138353_().m_138396_(new ResourceLocation("minecraft:husbandry/root")).m_138362_(new ItemStack((ItemLike)Salt.Items.SALT.get()), (Component)Salt.translate("salt.advancement.taste_explosion.title", new String[0]), (Component)Salt.translate("salt.advancement.taste_explosion.description", new String[0]), null, FrameType.TASK, true, true, false).m_138386_("eat_salted_food", (CriterionTriggerInstance)new SaltedFoodConsumedTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).save(advancementConsumer, Salt.resource("adventure/taste_explosion"), this.existingFileHelper);
            Advancement boil_off = Advancement.Builder.m_138353_().m_138398_(taste_explosion).m_138362_(new ItemStack((ItemLike)Items.f_42544_), (Component)Salt.translate("salt.advancement.boil_off.title", new String[0]), (Component)Salt.translate("salt.advancement.boil_off.description", new String[0]), null, FrameType.TASK, true, true, false).m_138386_("evaporate_water_to_form_salt", (CriterionTriggerInstance)new SaltEvaporationTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).save(advancementConsumer, Salt.resource("adventure/boil_off"), this.existingFileHelper);
            Advancement crystal_garden = Advancement.Builder.m_138353_().m_138398_(taste_explosion).m_138362_(new ItemStack((ItemLike)Salt.Items.SALT_CLUSTER.get()), (Component)Salt.translate("salt.advancement.crystal_garden.title", new String[0]), (Component)Salt.translate("salt.advancement.crystal_garden.description", new String[0]), null, FrameType.TASK, true, true, false).m_138386_("harvest_salt_crystal", (CriterionTriggerInstance)new HarvestSaltCrystalTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_)).save(advancementConsumer, Salt.resource("adventure/crystal_garden"), this.existingFileHelper);
        }
    }
}

