/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.mixin;

import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.Salting;
import io.github.mortuusars.salt.client.rendering.LayeredBakedModel;
import io.github.mortuusars.salt.configuration.Configuration;
import io.github.mortuusars.salt.helper.CallStackHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    private static final ResourceLocation SALT_OVERLAY = Salt.resource("item/salted_overlay");

    @Inject(method={"getModel"}, at={@At(value="RETURN")}, cancellable=true)
    private void getModel(ItemStack stack, Level level, LivingEntity entity, int idk, CallbackInfoReturnable<BakedModel> cir) {
        if (((Boolean)Configuration.SALTED_OVERLAY_ENABLED.get()).booleanValue() && Salting.isSalted(stack) && !CallStackHelper.isCalledFrom(CallStackHelper.ITEM_IN_HAND)) {
            BakedModel cachedModel = LayeredBakedModel.Cache.get(Item.m_41393_((Item)stack.m_41720_()));
            if (cachedModel != null) {
                cir.setReturnValue((Object)cachedModel);
            } else {
                BakedModel originalModel = (BakedModel)cir.getReturnValue();
                BakedModel saltOverlayModel = Minecraft.m_91087_().m_91304_().getModel(SALT_OVERLAY);
                LayeredBakedModel layeredModel = new LayeredBakedModel(List.of(originalModel, saltOverlayModel));
                LayeredBakedModel.Cache.add(Item.m_41393_((Item)stack.m_41720_()), layeredModel);
                cir.setReturnValue((Object)layeredModel);
            }
        }
    }
}

