/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.integration.jei.category;

import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.integration.jei.SaltJeiPlugin;
import io.github.mortuusars.salt.integration.jei.resource.SaltEvaporationDummy;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SaltEvaporationCategory
implements IRecipeCategory<SaltEvaporationDummy> {
    public static final ResourceLocation UID = Salt.resource("salt_evaporation");
    private static final ResourceLocation TEXTURE = Salt.resource("textures/gui/jei/salt_evaporation.png");
    private final Component title;
    private final IDrawable background;
    private final IDrawable icon;
    private final List<Component> waterCauldronTooltip = List.of(Salt.translate("block.minecraft.water_cauldron", new String[0]));
    private final List<Component> saltCauldronTooltip = List.of(Salt.translate("block.salt.salt_cauldron", new String[0]));
    private final List<Component> heatSourceTooltip = List.of(Salt.translate("gui.jei.category.salt_evaporation.heat_source.tooltip", new String[0]), Salt.translate("gui.jei.category.salt_evaporation.heat_source.tooltip_2", new String[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)Salt.BlockTags.HEATERS.f_203868_().toString()).m_130940_(ChatFormatting.GOLD)));

    public SaltEvaporationCategory(IGuiHelper guiHelper) {
        this.title = Salt.translate("gui.jei.category.salt_evaporation", new String[0]);
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 168, 90);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Salt.Items.SALT.get()));
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull SaltEvaporationDummy recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 15.0 && mouseX < 60.0 && mouseY >= 8.0 && mouseY < 50.0) {
            return this.waterCauldronTooltip;
        }
        if (mouseX >= 15.0 && mouseX < 60.0 && mouseY >= 50.0 && mouseY < 85.0) {
            return this.heatSourceTooltip;
        }
        if (mouseX >= 106.0 && mouseX < 153.0 && mouseY >= 31.0 && mouseY < 76.0) {
            return this.saltCauldronTooltip;
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, @NotNull SaltEvaporationDummy recipe, @NotNull IFocusGroup focuses) {
        Item salt = Objects.requireNonNull(ForgeRegistries.ITEMS.tags()).getTag(Salt.ItemTags.FORGE_SALTS).stream().findFirst().orElse((Item)Salt.Items.SALT.get());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 122, 14).addItemStack(new ItemStack((ItemLike)salt));
    }

    @NotNull
    public RecipeType<SaltEvaporationDummy> getRecipeType() {
        return SaltJeiPlugin.SALT_EVAPORATION_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

