/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.mortuusars.salt.Salt;
import io.github.mortuusars.salt.Salting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SaltingRecipe
extends CustomRecipe {
    private static final Ingredient CAN_BE_SALTED = Ingredient.m_204132_(Salt.ItemTags.CAN_BE_SALTED);
    private final String group;
    private final NonNullList<Ingredient> ingredients;

    public SaltingRecipe(ResourceLocation id, String group, NonNullList<Ingredient> ingredients) {
        super(id);
        this.group = group;
        this.ingredients = ingredients;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pContainer) {
        return NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public boolean matches(CraftingContainer craftingContainer, @NotNull Level level) {
        boolean hasFoodInput = false;
        NonNullList matches = NonNullList.m_122780_((int)this.ingredients.size(), (Object)false);
        int itemsCount = 0;
        for (int slotIndex = 0; slotIndex < craftingContainer.m_6643_(); ++slotIndex) {
            ItemStack stackInSlot = craftingContainer.m_8020_(slotIndex);
            if (stackInSlot.m_41619_()) continue;
            ++itemsCount;
            if (CAN_BE_SALTED.test(stackInSlot) && !hasFoodInput && !Salting.isSalted(stackInSlot)) {
                hasFoodInput = true;
            }
            for (int ingredientIndex = 0; ingredientIndex < this.ingredients.size(); ++ingredientIndex) {
                if (!((Ingredient)this.ingredients.get(ingredientIndex)).test(stackInSlot) || ((Boolean)matches.get(ingredientIndex)).booleanValue()) continue;
                matches.set(ingredientIndex, (Object)true);
            }
        }
        return hasFoodInput && matches.stream().allMatch(match -> match) && itemsCount == this.ingredients.size() + 1;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer craftingContainer) {
        for (int index = 0; index < craftingContainer.m_6643_(); ++index) {
            ItemStack itemStack = craftingContainer.m_8020_(index);
            if (!CAN_BE_SALTED.test(itemStack)) continue;
            ItemStack resultStack = itemStack.m_41777_();
            resultStack.m_41764_(1);
            return Salting.setSalted(resultStack);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 || height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Salt.RecipeSerializers.SALTING.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public Ingredient getFoodIngredient() {
        return CAN_BE_SALTED;
    }

    public static class Serializer
    implements RecipeSerializer<SaltingRecipe> {
        @NotNull
        public SaltingRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            return new SaltingRecipe(recipeId, group, this.getIngredients(json));
        }

        private NonNullList<Ingredient> getIngredients(JsonObject json) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for salting recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for salting recipe. The maximum is 9");
            }
            return ingredients;
        }

        public SaltingRecipe fromNetwork(@NotNull ResourceLocation recipeID, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            int ingredientsCount = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientsCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new SaltingRecipe(recipeID, group, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, SaltingRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
        }
    }
}

