/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.salt;

import io.github.mortuusars.salt.Melting;
import io.github.mortuusars.salt.advancement.HarvestSaltCrystalTrigger;
import io.github.mortuusars.salt.advancement.SaltEvaporationTrigger;
import io.github.mortuusars.salt.advancement.SaltedFoodConsumedTrigger;
import io.github.mortuusars.salt.block.SaltBlock;
import io.github.mortuusars.salt.block.SaltCauldronBlock;
import io.github.mortuusars.salt.block.SaltClusterBlock;
import io.github.mortuusars.salt.block.SaltSandBlock;
import io.github.mortuusars.salt.configuration.Configuration;
import io.github.mortuusars.salt.crafting.recipe.SaltingRecipe;
import io.github.mortuusars.salt.event.ClientEvents;
import io.github.mortuusars.salt.event.CommonEvents;
import io.github.mortuusars.salt.item.SaltItem;
import io.github.mortuusars.salt.world.feature.MineralDepositFeature;
import io.github.mortuusars.salt.world.feature.configurations.MineralDepositConfiguration;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="salt")
public class Salt {
    public static final String ID = "salt";

    public Salt() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        Configuration.init();
        modEventBus.addListener(Configuration::onConfigLoad);
        modEventBus.addListener(Configuration::onConfigReload);
        Blocks.BLOCKS.register(modEventBus);
        Items.ITEMS.register(modEventBus);
        Sounds.SOUNDS.register(modEventBus);
        EntityTypes.ENTITY_TYPES.register(modEventBus);
        RecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        WorldGenFeatures.FEATURES.register(modEventBus);
        ConfiguredFeatures.CONFIGURED_FEATURES.register(modEventBus);
        PlacedFeatures.PLACED_FEATURES.register(modEventBus);
        modEventBus.addListener(CommonEvents::onCommonSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(ClientEvents::onClientSetup);
            MinecraftForge.EVENT_BUS.addListener(ClientEvents::onItemTooltipEvent);
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static MutableComponent translate(String key, String ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static ResourceLocation resource(String path) {
        return new ResourceLocation(ID, path);
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)Items.SALT.get()), (DispenseItemBehavior)Melting.SALT_DISPENSER_BEHAVIOR);
    }

    public static class Blocks {
        private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"salt");
        public static final RegistryObject<SandBlock> SALT_BLOCK = BLOCKS.register("salt_block", () -> new SaltSandBlock(15193551, BlockBehaviour.Properties.m_60926_((BlockBehaviour)net.minecraft.world.level.block.Blocks.f_49992_)));
        public static final RegistryObject<SaltBlock> ROCK_SALT_ORE = BLOCKS.register("rock_salt_ore", () -> new SaltBlock(net.minecraft.world.level.block.Blocks.f_50069_.m_49966_(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155949_(MaterialColor.f_76420_).m_60977_().m_60978_(2.5f).m_60999_().m_60918_(Sounds.Types.SALT)));
        public static final RegistryObject<SaltBlock> DEEPSLATE_ROCK_SALT_ORE = BLOCKS.register("deepslate_rock_salt_ore", () -> new SaltBlock(net.minecraft.world.level.block.Blocks.f_152550_.m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROCK_SALT_ORE.get())).m_155949_(MaterialColor.f_76419_)));
        public static final RegistryObject<SaltBlock> RAW_ROCK_SALT_BLOCK = BLOCKS.register("raw_rock_salt_block", () -> new SaltBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ROCK_SALT_ORE.get())).m_60918_(Sounds.Types.SALT_CLUSTER)));
        public static final RegistryObject<SaltClusterBlock> SALT_CLUSTER = BLOCKS.register("salt_cluster", () -> new SaltClusterBlock(7, 3, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_155949_(MaterialColor.f_76420_).m_60977_().m_60978_(1.5f).m_60918_(Sounds.Types.SALT_CLUSTER).m_60953_(state -> 3).m_60988_()));
        public static final RegistryObject<SaltClusterBlock> LARGE_SALT_BUD = BLOCKS.register("large_salt_bud", () -> new SaltClusterBlock(5, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SALT_CLUSTER.get())).m_60953_(state -> 2).m_60918_(Sounds.Types.LARGE_SALT_BUD)));
        public static final RegistryObject<SaltClusterBlock> MEDIUM_SALT_BUD = BLOCKS.register("medium_salt_bud", () -> new SaltClusterBlock(4, 3, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SALT_CLUSTER.get())).m_60953_(state -> 2).m_60918_(Sounds.Types.MEDIUM_SALT_BUD)));
        public static final RegistryObject<SaltClusterBlock> SMALL_SALT_BUD = BLOCKS.register("small_salt_bud", () -> new SaltClusterBlock(3, 4, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SALT_CLUSTER.get())).m_60953_(state -> 1).m_60918_(Sounds.Types.SMALL_SALT_BUD)));
        public static final RegistryObject<SaltCauldronBlock> SALT_CAULDRON = BLOCKS.register("salt_cauldron", () -> new SaltCauldronBlock(LayeredCauldronBlock.f_153515_, CauldronInteraction.f_175606_));
        public static final RegistryObject<SaltBlock> SALT_LAMP = BLOCKS.register("salt_lamp", () -> new SaltBlock(net.minecraft.world.level.block.Blocks.f_50399_.m_49966_(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76413_).m_60918_(Sounds.Types.SALT).m_60977_().m_60978_(2.0f).m_60953_(blockState -> 15)));
    }

    public static class Items {
        private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"salt");
        public static final RegistryObject<Item> SALT = ITEMS.register("salt", () -> new SaltItem(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
        public static final RegistryObject<Item> RAW_ROCK_SALT = ITEMS.register("raw_rock_salt", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
        public static final RegistryObject<BlockItem> SALT_BLOCK = ITEMS.register("salt_block", () -> new BlockItem((Block)Blocks.SALT_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
        public static final RegistryObject<BlockItem> ROCK_SALT_ORE = ITEMS.register("rock_salt_ore", () -> new BlockItem((Block)Blocks.ROCK_SALT_ORE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
        public static final RegistryObject<BlockItem> DEEPSLATE_ROCK_SALT_ORE = ITEMS.register("deepslate_rock_salt_ore", () -> new BlockItem((Block)Blocks.DEEPSLATE_ROCK_SALT_ORE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
        public static final RegistryObject<BlockItem> RAW_ROCK_SALT_BLOCK = ITEMS.register("raw_rock_salt_block", () -> new BlockItem((Block)Blocks.RAW_ROCK_SALT_BLOCK.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
        public static final RegistryObject<BlockItem> SALT_CLUSTER = ITEMS.register("salt_cluster", () -> new BlockItem((Block)Blocks.SALT_CLUSTER.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
        public static final RegistryObject<BlockItem> LARGE_SALT_BUD = ITEMS.register("large_salt_bud", () -> new BlockItem((Block)Blocks.LARGE_SALT_BUD.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
        public static final RegistryObject<BlockItem> MEDIUM_SALT_BUD = ITEMS.register("medium_salt_bud", () -> new BlockItem((Block)Blocks.MEDIUM_SALT_BUD.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
        public static final RegistryObject<BlockItem> SMALL_SALT_BUD = ITEMS.register("small_salt_bud", () -> new BlockItem((Block)Blocks.SMALL_SALT_BUD.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
        public static final RegistryObject<BlockItem> SALT_LAMP = ITEMS.register("salt_lamp", () -> new BlockItem((Block)Blocks.SALT_LAMP.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)));
    }

    public static class Sounds {
        private static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"salt");
        public static final RegistryObject<SoundEvent> SALT_DISSOLVE = Sounds.registerBlockSound("salt.dissolve");
        public static final RegistryObject<SoundEvent> MELT = Sounds.registerBlockSound("melt");
        public static final RegistryObject<SoundEvent> CAULDRON_EVAPORATE = Sounds.registerBlockSound("cauldron.evaporate");
        public static final RegistryObject<SoundEvent> BUBBLE_POP = Sounds.registerBlockSound("bubble_pop");
        public static final RegistryObject<SoundEvent> SALT_CAULDRON_REMOVE_SALT = Sounds.registerBlockSound("salt_cauldron.remove_salt");
        public static final RegistryObject<SoundEvent> SALT_BREAK = Sounds.registerBlockSound("salt.break");
        public static final RegistryObject<SoundEvent> SALT_STEP = Sounds.registerBlockSound("salt.step");
        public static final RegistryObject<SoundEvent> SALT_PLACE = Sounds.registerBlockSound("salt.place");
        public static final RegistryObject<SoundEvent> SALT_HIT = Sounds.registerBlockSound("salt.hit");
        public static final RegistryObject<SoundEvent> SALT_FALL = Sounds.registerBlockSound("salt.fall");
        public static final RegistryObject<SoundEvent> SALT_CLUSTER_BREAK = Sounds.registerBlockSound("salt_cluster.break");
        public static final RegistryObject<SoundEvent> SALT_CLUSTER_STEP = Sounds.registerBlockSound("salt_cluster.step");
        public static final RegistryObject<SoundEvent> SALT_CLUSTER_PLACE = Sounds.registerBlockSound("salt_cluster.place");
        public static final RegistryObject<SoundEvent> SALT_CLUSTER_HIT = Sounds.registerBlockSound("salt_cluster.hit");
        public static final RegistryObject<SoundEvent> SALT_CLUSTER_FALL = Sounds.registerBlockSound("salt_cluster.fall");
        public static final RegistryObject<SoundEvent> LARGE_SALT_BUD_BREAK = Sounds.registerBlockSound("large_salt_bud.break");
        public static final RegistryObject<SoundEvent> LARGE_SALT_BUD_STEP = Sounds.registerBlockSound("large_salt_bud.step");
        public static final RegistryObject<SoundEvent> LARGE_SALT_BUD_PLACE = Sounds.registerBlockSound("large_salt_bud.place");
        public static final RegistryObject<SoundEvent> LARGE_SALT_BUD_HIT = Sounds.registerBlockSound("large_salt_bud.hit");
        public static final RegistryObject<SoundEvent> LARGE_SALT_BUD_FALL = Sounds.registerBlockSound("large_salt_bud.fall");
        public static final RegistryObject<SoundEvent> MEDIUM_SALT_BUD_BREAK = Sounds.registerBlockSound("medium_salt_bud.break");
        public static final RegistryObject<SoundEvent> MEDIUM_SALT_BUD_STEP = Sounds.registerBlockSound("medium_salt_bud.step");
        public static final RegistryObject<SoundEvent> MEDIUM_SALT_BUD_PLACE = Sounds.registerBlockSound("medium_salt_bud.place");
        public static final RegistryObject<SoundEvent> MEDIUM_SALT_BUD_HIT = Sounds.registerBlockSound("medium_salt_bud.hit");
        public static final RegistryObject<SoundEvent> MEDIUM_SALT_BUD_FALL = Sounds.registerBlockSound("medium_salt_bud.fall");
        public static final RegistryObject<SoundEvent> SMALL_SALT_BUD_BREAK = Sounds.registerBlockSound("small_salt_bud.break");
        public static final RegistryObject<SoundEvent> SMALL_SALT_BUD_STEP = Sounds.registerBlockSound("small_salt_bud.step");
        public static final RegistryObject<SoundEvent> SMALL_SALT_BUD_PLACE = Sounds.registerBlockSound("small_salt_bud.place");
        public static final RegistryObject<SoundEvent> SMALL_SALT_BUD_HIT = Sounds.registerBlockSound("small_salt_bud.hit");
        public static final RegistryObject<SoundEvent> SMALL_SALT_BUD_FALL = Sounds.registerBlockSound("small_salt_bud.fall");

        private static RegistryObject<SoundEvent> registerBlockSound(String name) {
            return SOUNDS.register("block.salt." + name, () -> new SoundEvent(Salt.resource("block.salt." + name)));
        }

        public static class Types {
            public static final SoundType SALT = new ForgeSoundType(1.0f, 1.0f, () -> SALT_BREAK.get(), () -> SALT_STEP.get(), () -> SALT_PLACE.get(), () -> SALT_HIT.get(), () -> SALT_FALL.get());
            public static final SoundType SALT_CLUSTER = new ForgeSoundType(1.0f, 1.0f, () -> SALT_CLUSTER_BREAK.get(), () -> SALT_CLUSTER_STEP.get(), () -> SALT_CLUSTER_PLACE.get(), () -> SALT_CLUSTER_HIT.get(), () -> SALT_CLUSTER_FALL.get());
            public static final SoundType LARGE_SALT_BUD = new ForgeSoundType(1.0f, 1.0f, () -> LARGE_SALT_BUD_BREAK.get(), () -> LARGE_SALT_BUD_STEP.get(), () -> LARGE_SALT_BUD_PLACE.get(), () -> LARGE_SALT_BUD_HIT.get(), () -> LARGE_SALT_BUD_FALL.get());
            public static final SoundType MEDIUM_SALT_BUD = new ForgeSoundType(1.0f, 1.0f, () -> MEDIUM_SALT_BUD_BREAK.get(), () -> MEDIUM_SALT_BUD_STEP.get(), () -> MEDIUM_SALT_BUD_PLACE.get(), () -> MEDIUM_SALT_BUD_HIT.get(), () -> MEDIUM_SALT_BUD_FALL.get());
            public static final SoundType SMALL_SALT_BUD = new ForgeSoundType(1.0f, 1.0f, () -> SMALL_SALT_BUD_BREAK.get(), () -> SMALL_SALT_BUD_STEP.get(), () -> SMALL_SALT_BUD_PLACE.get(), () -> SMALL_SALT_BUD_HIT.get(), () -> SMALL_SALT_BUD_FALL.get());
        }
    }

    public static class EntityTypes {
        private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"salt");
    }

    public static class RecipeSerializers {
        private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"salt");
        public static final RegistryObject<RecipeSerializer<?>> SALTING = RECIPE_SERIALIZERS.register("salting", () -> new SaltingRecipe.Serializer());
    }

    public static class WorldGenFeatures {
        private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"salt");
        public static final RegistryObject<Feature<MineralDepositConfiguration>> MINERAL_DEPOSIT = FEATURES.register("mineral_deposit", () -> new MineralDepositFeature(MineralDepositConfiguration.CODEC));
    }

    public static class ConfiguredFeatures {
        private static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"salt");
        private static final Supplier<MineralDepositConfiguration.DepositBlockStateInfo> ROCK_SALT_STONE_BLOCKS = () -> MineralDepositConfiguration.blockStateInfo((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((SaltBlock)Blocks.ROCK_SALT_ORE.get()).m_49966_(), 8).m_146271_((Object)((SaltBlock)Blocks.RAW_ROCK_SALT_BLOCK.get()).m_49966_(), 1).m_146270_()), OreFeatures.f_195072_);
        private static final Supplier<MineralDepositConfiguration.DepositBlockStateInfo> ROCK_SALT_DEEPSLATE_BLOCKS = () -> MineralDepositConfiguration.blockStateInfo((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((SaltBlock)Blocks.DEEPSLATE_ROCK_SALT_ORE.get()).m_49966_(), 8).m_146271_((Object)((SaltBlock)Blocks.RAW_ROCK_SALT_BLOCK.get()).m_49966_(), 1).m_146270_()), OreFeatures.f_195073_);
        private static final Supplier<MineralDepositConfiguration.DepositBlockStateInfo> ROCK_SALT_CLUSTERS = () -> MineralDepositConfiguration.blockStateInfo((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((SaltClusterBlock)Blocks.SALT_CLUSTER.get()).m_49966_(), 16).m_146271_((Object)((SaltClusterBlock)Blocks.LARGE_SALT_BUD.get()).m_49966_(), 2).m_146271_((Object)((SaltClusterBlock)Blocks.MEDIUM_SALT_BUD.get()).m_49966_(), 1).m_146271_((Object)((SaltClusterBlock)Blocks.SMALL_SALT_BUD.get()).m_49966_(), 1).m_146270_()), (RuleTest)new TagMatchTest(BlockTags.SALT_CLUSTER_REPLACEABLES));
        public static final RegistryObject<ConfiguredFeature<?, ?>> ROCK_SALT = CONFIGURED_FEATURES.register("mineral_rock_salt", () -> new ConfiguredFeature((Feature)WorldGenFeatures.MINERAL_DEPOSIT.get(), (FeatureConfiguration)new MineralDepositConfiguration(List.of(ROCK_SALT_STONE_BLOCKS.get(), ROCK_SALT_DEEPSLATE_BLOCKS.get()), ROCK_SALT_CLUSTERS.get())));
    }

    public static class PlacedFeatures {
        private static final DeferredRegister<PlacedFeature> PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"salt");
    }

    public static class BiomeTags {
        public static final TagKey<Biome> HAS_ROCK_SALT_DEPOSITS = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)Salt.resource("has_rock_salt_deposits"));
    }

    public static class BlockTags {
        public static final TagKey<Block> HEATERS = net.minecraft.tags.BlockTags.create((ResourceLocation)Salt.resource("heaters"));
        public static final TagKey<Block> SALT_CLUSTER_GROWABLES = net.minecraft.tags.BlockTags.create((ResourceLocation)Salt.resource("salt_cluster_growables"));
        public static final TagKey<Block> SALT_DISSOLVABLES = net.minecraft.tags.BlockTags.create((ResourceLocation)Salt.resource("salt_dissolvables"));
        public static final TagKey<Block> MELTABLES = net.minecraft.tags.BlockTags.create((ResourceLocation)Salt.resource("meltables"));
        public static final TagKey<Block> SALT_CLUSTER_REPLACEABLES = net.minecraft.tags.BlockTags.create((ResourceLocation)Salt.resource("salt_cluster_replaceables"));
    }

    public static class ItemTags {
        public static final TagKey<Item> CAN_BE_SALTED = net.minecraft.tags.ItemTags.create((ResourceLocation)Salt.resource("can_be_salted"));
        public static final TagKey<Item> FORGE_SALTS = net.minecraft.tags.ItemTags.create((ResourceLocation)new ResourceLocation("forge", "salts"));
        public static final TagKey<Item> FORGE_TORCHES = net.minecraft.tags.ItemTags.create((ResourceLocation)new ResourceLocation("forge:torches"));
    }

    public static class Advancements {
        public static SaltEvaporationTrigger SALT_EVAPORATED = new SaltEvaporationTrigger();
        public static SaltedFoodConsumedTrigger SALTED_FOOD_CONSUMED = new SaltedFoodConsumedTrigger();
        public static HarvestSaltCrystalTrigger HARVEST_SALT_CRYSTAL = new HarvestSaltCrystalTrigger();

        public static void register() {
            CriteriaTriggers.m_10595_((CriterionTrigger)SALT_EVAPORATED);
            CriteriaTriggers.m_10595_((CriterionTrigger)SALTED_FOOD_CONSUMED);
            CriteriaTriggers.m_10595_((CriterionTrigger)HARVEST_SALT_CRYSTAL);
        }
    }
}

