/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class TerrainFallbackConsumer
extends AbstractQuadRenderer
implements RenderContext.BakedModelConsumer {
    private static final RenderMaterialImpl.Value MATERIAL_FLAT = (RenderMaterialImpl.Value)IndigoRenderer.INSTANCE.materialFinder().disableAo(0, true).find();
    private static final RenderMaterialImpl.Value MATERIAL_SHADED = (RenderMaterialImpl.Value)IndigoRenderer.INSTANCE.materialFinder().find();
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.material(MATERIAL_SHADED);
        }

        @Override
        public QuadEmitter emit() {
            throw new UnsupportedOperationException("Fallback consumer does not support .emit()");
        }
    };

    TerrainFallbackConsumer(BlockRenderInfo blockInfo, Function<RenderType, VertexConsumer> bufferFunc, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(blockInfo, bufferFunc, aoCalc, transform);
    }

    @Override
    public void accept(BakedModel bakedModel) {
        this.accept(bakedModel, this.blockInfo.blockState);
    }

    @Override
    public void accept(BakedModel model, @Nullable BlockState blockState) {
        Supplier<RandomSource> random = this.blockInfo.randomSupplier;
        RenderMaterialImpl.Value defaultMaterial = this.blockInfo.defaultAo && model.m_7541_() ? MATERIAL_SHADED : MATERIAL_FLAT;
        for (int i = 0; i <= 6; ++i) {
            Direction cullFace = ModelHelper.faceFromIndex(i);
            List quads = model.getQuads(blockState, cullFace, random.get(), this.blockInfo.modelData, this.blockInfo.layer);
            int count = quads.size();
            if (count == 0) continue;
            for (int j = 0; j < count; ++j) {
                BakedQuad q = (BakedQuad)quads.get(j);
                this.renderQuad(q, cullFace, defaultMaterial);
            }
        }
    }

    private void renderQuad(BakedQuad quad, Direction cullFace, RenderMaterialImpl.Value defaultMaterial) {
        MutableQuadViewImpl editorQuad = this.editorQuad;
        editorQuad.fromVanilla(quad, defaultMaterial, cullFace);
        this.renderQuad(editorQuad, true);
    }
}

