/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class BlockRenderInfo {
    private final BlockColors blockColorMap = Minecraft.m_91087_().m_91298_();
    private final BlockPos.MutableBlockPos searchPos = new BlockPos.MutableBlockPos();
    private final RandomSource random = RandomSource.m_216327_();
    public BlockAndTintGetter blockView;
    public BlockPos blockPos;
    public BlockState blockState;
    public long seed;
    boolean defaultAo;
    RenderType defaultLayer;
    public ModelData modelData;
    public RenderType layer;
    private boolean enableCulling;
    private int cullCompletionFlags;
    private int cullResultFlags;
    public final Supplier<RandomSource> randomSupplier = () -> {
        RandomSource result = this.random;
        long seed = this.seed;
        if (seed == -1L) {
            this.seed = seed = this.blockState.m_60726_(this.blockPos);
        }
        result.m_188584_(seed);
        return result;
    };

    public void prepareForWorld(BlockAndTintGetter blockView, boolean enableCulling) {
        this.blockView = blockView;
        this.enableCulling = enableCulling;
    }

    public void prepareForBlock(BlockAndTintGetter blockView, BlockState blockState, BlockPos blockPos, boolean modelAO, ModelData modelData, RenderType layer) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.modelData = modelData;
        this.layer = layer;
        this.seed = -1L;
        this.defaultAo = modelAO && Minecraft.m_91086_() && blockState.getLightEmission((BlockGetter)blockView, blockPos) == 0;
        this.defaultLayer = layer;
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    public void release() {
        this.blockPos = null;
        this.blockState = null;
    }

    int blockColor(int colorIndex) {
        return 0xFF000000 | this.blockColorMap.m_92577_(this.blockState, this.blockView, this.blockPos, colorIndex);
    }

    boolean shouldDrawFace(@Nullable Direction face) {
        if (face == null || !this.enableCulling) {
            return true;
        }
        int mask = 1 << face.m_122411_();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (Block.m_152444_((BlockState)this.blockState, (BlockGetter)this.blockView, (BlockPos)this.blockPos, (Direction)face, (BlockPos)this.searchPos.m_122159_((Vec3i)this.blockPos, face))) {
                this.cullResultFlags |= mask;
                return true;
            }
            return false;
        }
        return (this.cullResultFlags & mask) != 0;
    }

    RenderType effectiveRenderLayer(BlendMode blendMode) {
        return blendMode == BlendMode.DEFAULT ? this.defaultLayer : blendMode.blockRenderLayer;
    }
}

