/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Consumer;
import java.util.function.Function;
import link.infra.indium.mixin.sodium.AccessBlockRenderer;
import link.infra.indium.renderer.accessor.AccessChunkRenderCacheLocal;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.render.AbstractRenderContext;
import link.infra.indium.renderer.render.BaseFallbackConsumer;
import link.infra.indium.renderer.render.BaseMeshConsumer;
import link.infra.indium.renderer.render.ChunkQuadBufferer;
import link.infra.indium.renderer.render.ChunkRenderInfo;
import link.infra.indium.renderer.render.TerrainBlockRenderInfo;
import me.jellysquid.mods.sodium.client.gl.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.model.light.cache.ArrayLightDataCache;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;

public class TerrainRenderContext
extends AbstractRenderContext {
    private final TerrainBlockRenderInfo blockInfo;
    private final ChunkRenderInfo chunkInfo;
    private final AoCalculator aoCalc;
    private Vec3i origin;
    private Vec3 modelOffset;
    private final BaseMeshConsumer meshConsumer;
    private final BaseFallbackConsumer fallbackConsumer;

    public TerrainRenderContext(ChunkRenderCacheLocal renderCache) {
        WorldSlice worldSlice = renderCache.getWorldSlice();
        BlockOcclusionCache blockOcclusionCache = ((AccessBlockRenderer)renderCache.getBlockRenderer()).indium$occlusionCache();
        ArrayLightDataCache lightCache = ((AccessChunkRenderCacheLocal)renderCache).indium$getLightDataCache();
        this.blockInfo = new TerrainBlockRenderInfo(blockOcclusionCache);
        this.blockInfo.setBlockView((BlockAndTintGetter)worldSlice);
        this.chunkInfo = new ChunkRenderInfo((BlockAndTintGetter)worldSlice);
        this.aoCalc = new AoCalculator(this.blockInfo, (LightDataAccess)lightCache);
        this.meshConsumer = new BaseMeshConsumer(new QuadBufferer(this.chunkInfo::getChunkModelBuilder), this.blockInfo, this.aoCalc, this::transform);
        this.fallbackConsumer = new BaseFallbackConsumer(new QuadBufferer(this.chunkInfo::getChunkModelBuilder), this.blockInfo, this.aoCalc, this::transform);
    }

    public static TerrainRenderContext get(ChunkBuildContext buildContext) {
        return ((AccessChunkRenderCacheLocal)buildContext.cache).indium$getTerrainRenderContext();
    }

    public void prepare(ChunkBuildContext buildContext) {
        this.chunkInfo.prepare(buildContext.buffers);
    }

    public void release() {
        this.blockInfo.release();
        this.chunkInfo.release();
    }

    public boolean tessellateBlock(BlockGetter level, BlockState blockState, BlockPos blockPos, BlockPos origin, BakedModel model, Vec3 modelOffset, ModelData modelData, RenderType layer) {
        this.origin = origin;
        this.modelOffset = modelOffset;
        try {
            this.chunkInfo.didOutput = false;
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(level, blockState, blockPos, model.m_7541_(), modelData, layer);
            ((FabricBakedModel)model).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, this);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Tessellating block in world - Reforgium Renderer");
            CrashReportCategory crashReportSection = crashReport.m_127514_("Block being tessellated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashReportSection, (LevelHeightAccessor)this.chunkInfo.blockView, (BlockPos)blockPos, (BlockState)blockState);
            throw new ReportedException(crashReport);
        }
        return this.chunkInfo.didOutput;
    }

    @Override
    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    @Override
    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.fallbackConsumer;
    }

    @Override
    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }

    private class QuadBufferer
    extends ChunkQuadBufferer {
        QuadBufferer(Function<RenderType, ChunkModelBuilder> builderFunc) {
            super(builderFunc);
        }

        @Override
        protected Vec3i origin() {
            return TerrainRenderContext.this.origin;
        }

        @Override
        protected Vec3 blockOffset() {
            return TerrainRenderContext.this.modelOffset;
        }
    }
}

