/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class BlockRenderInfo {
    private final BlockColors blockColorMap = Minecraft.m_91087_().m_91298_();
    public final RandomSource random = RandomSource.m_216327_();
    public BlockAndTintGetter blockView;
    public BlockPos blockPos;
    public BlockState blockState;
    public long seed;
    boolean defaultAo;
    RenderType defaultLayer;
    public ModelData modelData;
    public RenderType layer;
    public final Supplier<RandomSource> randomSupplier = () -> {
        RandomSource result = this.random;
        long seed = this.seed;
        if (seed == -1L) {
            this.seed = seed = this.blockState.m_60726_(this.blockPos);
        }
        result.m_188584_(seed);
        return result;
    };

    public void setBlockView(BlockAndTintGetter blockView) {
        this.blockView = blockView;
    }

    public void prepareForBlock(BlockGetter level, BlockState blockState, BlockPos blockPos, boolean modelAO, ModelData modelData, RenderType layer) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.modelData = modelData;
        this.layer = layer;
        this.seed = -1L;
        this.defaultAo = modelAO && Minecraft.m_91086_() && blockState.getLightEmission(level, blockPos) == 0;
        this.defaultLayer = layer;
    }

    public void release() {
        this.blockPos = null;
        this.blockState = null;
    }

    int blockColor(int colorIndex) {
        return 0xFF000000 | this.blockColorMap.m_92577_(this.blockState, this.blockView, this.blockPos, colorIndex);
    }

    boolean shouldDrawFace(Direction face) {
        return true;
    }

    RenderType effectiveRenderLayer(BlendMode blendMode) {
        return blendMode == BlendMode.DEFAULT ? this.defaultLayer : blendMode.blockRenderLayer;
    }
}

