/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.List;
import java.util.function.Supplier;
import link.infra.indium.renderer.ReforgiumRenderer;
import link.infra.indium.renderer.RenderMaterialImpl;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import link.infra.indium.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BaseFallbackConsumer
extends BaseQuadRenderer
implements RenderContext.BakedModelConsumer {
    private static final RenderMaterialImpl.Value MATERIAL_FLAT = (RenderMaterialImpl.Value)ReforgiumRenderer.INSTANCE.materialFinder().disableAo(0, true).find();
    private static final RenderMaterialImpl.Value MATERIAL_SHADED = (RenderMaterialImpl.Value)ReforgiumRenderer.INSTANCE.materialFinder().find();
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.material(MATERIAL_SHADED);
        }

        @Override
        public QuadEmitter emit() {
            throw new UnsupportedOperationException("Fallback consumer does not support .emit()");
        }
    };

    BaseFallbackConsumer(BaseQuadRenderer.QuadBufferer bufferer, BlockRenderInfo blockInfo, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(bufferer, blockInfo, aoCalc, transform);
    }

    @Override
    public void accept(BakedModel model) {
        this.accept(model, this.blockInfo.blockState);
    }

    @Override
    public void accept(BakedModel model, @Nullable BlockState state) {
        Supplier<RandomSource> random = this.blockInfo.randomSupplier;
        RenderMaterialImpl.Value defaultMaterial = this.blockInfo.defaultAo && model.m_7541_() ? MATERIAL_SHADED : MATERIAL_FLAT;
        for (int i = 0; i <= 6; ++i) {
            Direction cullFace = ModelHelper.faceFromIndex(i);
            List quads = model.getQuads(state, cullFace, random.get(), this.blockInfo.modelData, this.blockInfo.layer);
            int count = quads.size();
            if (count == 0) continue;
            for (int j = 0; j < count; ++j) {
                BakedQuad q = (BakedQuad)quads.get(j);
                this.renderQuad(q, cullFace, defaultMaterial);
            }
        }
    }

    private void renderQuad(BakedQuad quad, Direction cullFace, RenderMaterialImpl.Value defaultMaterial) {
        MutableQuadViewImpl editorQuad = this.editorQuad;
        editorQuad.fromVanilla(quad, defaultMaterial, cullFace);
        this.renderQuad(editorQuad, true);
    }
}

