/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;

abstract class AbstractRenderContext
implements RenderContext {
    private static final RenderContext.QuadTransform NO_TRANSFORM = q -> true;
    private RenderContext.QuadTransform activeTransform = NO_TRANSFORM;
    private final ObjectArrayList<RenderContext.QuadTransform> transformStack = new ObjectArrayList();
    private final RenderContext.QuadTransform stackTransform = q -> {
        int i = this.transformStack.size() - 1;
        while (i >= 0) {
            if (((RenderContext.QuadTransform)this.transformStack.get(i--)).transform(q)) continue;
            return false;
        }
        return true;
    };

    AbstractRenderContext() {
    }

    protected final boolean transform(MutableQuadView q) {
        return this.activeTransform.transform(q);
    }

    protected boolean hasTransform() {
        return this.activeTransform != NO_TRANSFORM;
    }

    @Override
    public void pushTransform(RenderContext.QuadTransform transform) {
        if (transform == null) {
            throw new NullPointerException("Renderer received null QuadTransform.");
        }
        this.transformStack.push((Object)transform);
        if (this.transformStack.size() == 1) {
            this.activeTransform = transform;
        } else if (this.transformStack.size() == 2) {
            this.activeTransform = this.stackTransform;
        }
    }

    @Override
    public void popTransform() {
        this.transformStack.pop();
        if (this.transformStack.size() == 0) {
            this.activeTransform = NO_TRANSFORM;
        } else if (this.transformStack.size() == 1) {
            this.activeTransform = (RenderContext.QuadTransform)this.transformStack.get(0);
        }
    }
}

