/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.mesh;

import java.util.function.Consumer;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.QuadViewImpl;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;

public class MeshImpl
implements Mesh {
    ThreadLocal<QuadViewImpl> POOL = ThreadLocal.withInitial(QuadViewImpl::new);
    final int[] data;

    MeshImpl(int[] data) {
        this.data = data;
    }

    public int[] data() {
        return this.data;
    }

    @Override
    public void forEach(Consumer<QuadView> consumer) {
        this.forEach(consumer, this.POOL.get());
    }

    void forEach(Consumer<QuadView> consumer, QuadViewImpl cursor) {
        int limit = this.data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            cursor.load(this.data, index);
            consumer.accept(cursor);
        }
    }
}

