/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium;

import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.ReforgiumRenderer;
import link.infra.indium.renderer.aocalc.AoConfig;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.impl.client.indigo.Indigo;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

@Mod(value="reforgium")
public class Indium {
    public static final boolean ALWAYS_TESSELLATE_INDIUM;
    public static final AoConfig AMBIENT_OCCLUSION_MODE;
    public static final boolean FIX_EXTERIOR_VERTEX_LIGHTING;
    public static final Logger LOGGER;
    public static boolean rubidiumLoaded;

    private static boolean asBoolean(String property, boolean defValue) {
        Boolean bool = Indium.asBool(property);
        return bool == null ? defValue : bool;
    }

    private static <T extends Enum> T asEnum(String property, T defValue) {
        if (property == null || property.isEmpty()) {
            return defValue;
        }
        for (Enum obj : (Enum[])defValue.getClass().getEnumConstants()) {
            if (!property.equalsIgnoreCase(obj.name())) continue;
            return (T)obj;
        }
        return defValue;
    }

    private static Boolean asBool(String property) {
        if (property == null || property.isEmpty()) {
            return null;
        }
        switch (property.toLowerCase(Locale.ROOT)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        return null;
    }

    public Indium() {
        if (rubidiumLoaded) {
            RendererAccess.INSTANCE.registerRenderer(ReforgiumRenderer.INSTANCE);
        } else {
            Indigo.init();
        }
        if (rubidiumLoaded) {
            FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        }
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public void addListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)SpriteFinderCache.ReloadListener.INSTANCE);
    }

    static {
        Closeable stream;
        LOGGER = LogUtils.getLogger();
        Path configFile = FMLPaths.CONFIGDIR.get().resolve("reforgium-renderer.properties");
        Properties properties = new Properties();
        if (Files.exists(configFile, new LinkOption[0])) {
            try {
                stream = Files.newInputStream(configFile, new OpenOption[0]);
                try {
                    properties.load((InputStream)stream);
                }
                finally {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("[Reforgium] Could not read property file '" + configFile.toAbsolutePath() + "'", (Throwable)e);
            }
        }
        ALWAYS_TESSELLATE_INDIUM = Indium.asBoolean((String)properties.computeIfAbsent("always-tesselate-blocks", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), false);
        AMBIENT_OCCLUSION_MODE = Indium.asEnum((String)properties.computeIfAbsent("ambient-occlusion-mode", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), AoConfig.ENHANCED);
        FIX_EXTERIOR_VERTEX_LIGHTING = Indium.asBoolean((String)properties.computeIfAbsent("fix-exterior-vertex-lighting", (Function<? super Object, ?>)((Function<Object, Object>)a -> "auto")), true);
        try {
            stream = Files.newOutputStream(configFile, new OpenOption[0]);
            try {
                properties.store((OutputStream)stream, "Reforgium properties file");
            }
            finally {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("[Reforgium] Could not store property file '" + configFile.toAbsolutePath() + "'", (Throwable)e);
        }
        rubidiumLoaded = FMLLoader.getLoadingModList().getModFileById("rubidium") != null;
    }
}

