/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.mixin.nbt;

import com.recipeessentials.nbt.IParentAwareTag;
import com.recipeessentials.nbt.IParentTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ListTag.class})
public class ListTagMixin
implements IParentAwareTag {
    @Unique
    private IParentTag parentTag = null;

    @Override
    public void setParent(IParentTag tag) {
        this.parentTag = tag;
    }

    @Override
    public IParentTag parent() {
        return this.parentTag;
    }

    @Inject(method={"remove(I)Lnet/minecraft/nbt/Tag;"}, at={@At(value="RETURN")})
    private void onRemove(int p_128751_, CallbackInfoReturnable<Tag> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"getCompound"}, at={@At(value="RETURN")})
    private void onGetCompound(int p_128729_, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag r;
        if (this.parentTag != null && (r = (CompoundTag)cir.getReturnValue()) instanceof IParentAwareTag) {
            ((IParentAwareTag)r).setParent(this.parentTag);
        }
    }

    @Inject(method={"getList"}, at={@At(value="RETURN")})
    private void onGetList(int p_128729_, CallbackInfoReturnable<ListTag> cir) {
        ListTag r;
        if (this.parentTag != null && (r = (ListTag)cir.getReturnValue()) instanceof IParentAwareTag) {
            ((IParentAwareTag)r).setParent(this.parentTag);
        }
    }

    @Inject(method={"set(ILnet/minecraft/nbt/Tag;)Lnet/minecraft/nbt/Tag;"}, at={@At(value="RETURN")})
    private void onSet(int p_128760_, Tag p_128761_, CallbackInfoReturnable<Tag> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"setTag"}, at={@At(value="RETURN")})
    private void onSetTag(int p_128218_, Tag p_128219_, CallbackInfoReturnable<Boolean> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"addTag"}, at={@At(value="RETURN")})
    private void onAddTag(int p_128218_, Tag p_128219_, CallbackInfoReturnable<Boolean> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"clear"}, at={@At(value="RETURN")})
    private void onClear(CallbackInfo ci) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }
}

