/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs;

import com.decursioteam.pickableorbs.client.HPClient;
import com.decursioteam.pickableorbs.config.CommonConfig;
import com.decursioteam.pickableorbs.config.Readme;
import com.decursioteam.pickableorbs.datagen.OrbsData;
import com.decursioteam.pickableorbs.entities.HalfHeartEntity;
import com.decursioteam.pickableorbs.registries.OrbsRegistry;
import com.decursioteam.pickableorbs.registries.Registry;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pickableorbs")
@Mod.EventBusSubscriber(modid="pickableorbs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PickableOrbs {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "pickableorbs";

    public PickableOrbs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.config, "pickableorbs/common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Readme.config, "pickableorbs/readme.toml");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Registry.REGISTRY.register(bus);
        Registry.setupOrbs();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> HPClient::register);
        }
        MinecraftForge.EVENT_BUS.addListener(this::entityDropEvent);
        MinecraftForge.EVENT_BUS.addListener(this::blockBreakEvent);
        CommonConfig.loadConfig(CommonConfig.config, FMLPaths.CONFIGDIR.get().resolve("pickableorbs/common.toml").toString());
        if (((Boolean)CommonConfig.generate_defaults.get()).booleanValue()) {
            Registry.setupDefaultOrbs();
            CommonConfig.generate_defaults.set((Object)false);
            CommonConfig.generate_defaults.save();
        }
        OrbsRegistry.ORB_TYPES.register(bus);
        Registry.registerOrbTypes();
    }

    private void blockBreakEvent(BlockEvent.BreakEvent e) {
        Level world = (Level)e.getLevel();
        OrbsRegistry.getOrbs().forEach((s, entityType) -> {
            List<ResourceLocation> blockSet = OrbsData.getOrbData(s).getData().getBlockSet();
            String blockListType = OrbsData.getOrbData(s).getData().getBlockListType();
            double blockDropChance = OrbsData.getOrbData(s).getData().getBlockDropChance();
            Random random = new Random();
            if (blockListType.equalsIgnoreCase("whitelist")) {
                if (blockSet.contains(ForgeRegistries.BLOCKS.getKey((Object)e.getState().m_60734_())) && blockDropChance != 0.0 && blockDropChance >= random.nextDouble() * 100.0) {
                    world.m_7967_((Entity)new HalfHeartEntity((EntityType<HalfHeartEntity>)((EntityType)entityType.get()), world, e.getPos().m_123341_(), e.getPos().m_123342_(), e.getPos().m_123343_(), (String)s, OrbsData.getOrbData(s)));
                }
            } else if (blockListType.equalsIgnoreCase("blacklist") && !blockSet.contains(ForgeRegistries.BLOCKS.getKey((Object)e.getState().m_60734_())) && blockDropChance != 0.0 && blockDropChance >= random.nextDouble() * 100.0) {
                world.m_7967_((Entity)new HalfHeartEntity((EntityType<HalfHeartEntity>)((EntityType)entityType.get()), world, e.getPos().m_123341_(), e.getPos().m_123342_(), e.getPos().m_123343_(), (String)s, OrbsData.getOrbData(s)));
            }
        });
    }

    private void entityDropEvent(LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        Level world = entity.m_20193_();
        Entity sourceEntity = e.getSource().m_7639_();
        if (sourceEntity instanceof Player) {
            OrbsRegistry.getOrbs().forEach((s, entityType) -> {
                List<ResourceLocation> entitySet = OrbsData.getOrbData(s).getData().getEntitySet();
                String entityListType = OrbsData.getOrbData(s).getData().getEntityListType();
                double entityDropChance = OrbsData.getOrbData(s).getData().getEntityDropChance();
                Random random = new Random();
                if (entityListType.equalsIgnoreCase("whitelist")) {
                    if (entitySet.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())) && entityDropChance != 0.0 && entityDropChance >= random.nextDouble() * 100.0) {
                        world.m_7967_((Entity)new HalfHeartEntity((EntityType<HalfHeartEntity>)((EntityType)entityType.get()), world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (String)s, OrbsData.getOrbData(s)));
                    }
                } else if (entityListType.equalsIgnoreCase("blacklist") && !entitySet.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())) && entityDropChance != 0.0 && entityDropChance >= random.nextDouble() * 100.0) {
                    world.m_7967_((Entity)new HalfHeartEntity((EntityType<HalfHeartEntity>)((EntityType)entityType.get()), world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (String)s, OrbsData.getOrbData(s)));
                }
            });
        }
    }
}

