/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config.dynamic;

import java.util.Map;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.player.config.dynamic.PlayerConfigDynamicOptions;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionType;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroup;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigListIterationOptionSpec;
import xaero.pac.common.server.player.config.PlayerConfigStaticListIterationOptionSpec;

public class PlayerConfigExceptionDynamicOptionsLoader {
    public static final String OPTION_ROOT = "playerConfig.claims.protection.exceptionGroups.";
    public static final String TRANSLATION_ROOT = "gui.xaero_pac_player_config_playerConfig.claims.protection.exceptionGroups.";
    public static final String COMMENT_TRANSLATION_ROOT = "gui.xaero_pac_player_config_tooltip_playerConfig.claims.protection.exceptionGroups.";
    public static final String INTERACT = "interact";
    public static final String HAND_INTERACT = "handInteract";
    public static final String ANY_ITEM_INTERACT = "anyItemInteract";
    public static final String BREAK = "break";
    public static final String BARRIER = "barrier";
    public static final String BLOCK_ACCESS = "blockAccess";
    public static final String ENTITY_ACCESS = "entityAccess";
    public static final String DROPPED_ITEM_ACCESS = "droppedItemAccess";

    <T> void handleGroup(ChunkProtectionExceptionGroup<T> group, PlayerConfigDynamicOptions.Builder builder, String category, String categoryPlural) {
        String commentTranslation;
        String translation;
        Object comment;
        String optionId;
        String interactionOptionsTooltip = "\n\n1) Party - players or entities owned by players in the same party as you.\n2) Allies - players or entities owned by players in parties that are allied by yours.\n3) Every - all players/entities.";
        if (group.getType() == ChunkProtectionExceptionType.INTERACTION) {
            optionId = OPTION_ROOT + category + ".interact";
            comment = "When enabled, claimed chunk protection makes an exception for interaction with the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".interact";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".interact";
        } else if (group.getType() == ChunkProtectionExceptionType.EMPTY_HAND_INTERACTION) {
            optionId = OPTION_ROOT + category + ".handInteract";
            comment = "When enabled, claimed chunk protection makes an exception for interaction with an empty hand with the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".handInteract";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".handInteract";
        } else if (group.getType() == ChunkProtectionExceptionType.ANY_ITEM_INTERACTION) {
            optionId = OPTION_ROOT + category + ".anyItemInteract";
            comment = "When enabled, claimed chunk protection makes an exception for interaction with any item held with the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".anyItemInteract";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".anyItemInteract";
        } else if (group.getType() == ChunkProtectionExceptionType.BREAK) {
            optionId = OPTION_ROOT + category + ".break";
            comment = "When enabled, claimed chunk protection makes an exception for destruction of the following " + categoryPlural + ": %1$s." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".break";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".break";
        } else if (group.getType() == ChunkProtectionExceptionType.BARRIER) {
            optionId = OPTION_ROOT + category + ".barrier";
            comment = "When enabled, claimed chunk protection prevents the following additional " + categoryPlural + " from entering the claim (except wilderness): %1$s.\n\n1) Every - protected from all players/entities that don't have chunk access.\n2) Not Party - only players/entities not in the same party as you.\n3) Not Ally - only players/entities not in any party allied by yours.";
            translation = TRANSLATION_ROOT + category + ".barrier";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".barrier";
        } else if (group.getType() == ChunkProtectionExceptionType.BLOCK_ACCESS) {
            optionId = OPTION_ROOT + category + ".blockAccess";
            comment = "When enabled, claimed chunk protection makes an exception for block access by the following " + categoryPlural + ": %1$s. If the block protection is based on the mob griefing rule check, then the claimed neighbor chunks must also allow the block access." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".blockAccess";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".blockAccess";
        } else if (group.getType() == ChunkProtectionExceptionType.ENTITY_ACCESS) {
            optionId = OPTION_ROOT + category + ".entityAccess";
            comment = "When enabled, claimed chunk protection makes an exception for entity access BY the following " + categoryPlural + ": %1$s. If the entity protection is based on the mob griefing rule check, then the claimed neighbor chunks must also allow the entity access." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".entityAccess";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".entityAccess";
        } else if (group.getType() == ChunkProtectionExceptionType.DROPPED_ITEM_ACCESS) {
            optionId = OPTION_ROOT + category + ".droppedItemAccess";
            comment = "When enabled, claimed chunk protection makes an exception for dropped item access by the following " + categoryPlural + ": %1$s. If the dropped item protection is based on the mob griefing rule check, then the claimed neighbor chunks must also allow the item access." + interactionOptionsTooltip;
            translation = TRANSLATION_ROOT + category + ".droppedItemAccess";
            commentTranslation = COMMENT_TRANSLATION_ROOT + category + ".droppedItemAccess";
        } else {
            OpenPartiesAndClaims.LOGGER.error("Invalid group type " + group.getType() + " for " + category + " exception group " + group.getName());
            return;
        }
        optionId = optionId + "." + group.getName();
        comment = String.format((String)comment, group.getContentString());
        PlayerConfigListIterationOptionSpec option = ((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)((PlayerConfigStaticListIterationOptionSpec.Builder)PlayerConfigStaticListIterationOptionSpec.Builder.begin(Integer.class).setId(optionId)).setList(PlayerConfig.PROTECTION_LEVELS).setTranslation(translation, group.getName())).setCommentTranslation(commentTranslation, group.getContentString())).setDefaultValue(0)).setComment((String)comment)).setCategory(group.getOptionCategory())).setDynamic(true)).build((Map)null);
        group.setPlayerConfigOption(option);
        builder.addOption(option);
    }
}

