/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.task;

import java.util.Iterator;
import java.util.List;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;
import xaero.pac.common.server.task.IServerSpreadoutQueuedTask;

public class PartyRemovalSpreadoutTask
implements IServerSpreadoutQueuedTask<PartyRemovalSpreadoutTask> {
    private final PartyManager partyManager;
    private final ServerParty party;
    private Iterator<PartyMember> memberIterator;
    private Iterator<PartyAlly> allyIterator;
    private boolean done;

    public PartyRemovalSpreadoutTask(PartyManager partyManager, ServerParty party) {
        this.partyManager = partyManager;
        this.party = party;
    }

    @Override
    public void onQueued(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
        this.memberIterator = this.party.getPartyMemberIterator();
        this.allyIterator = this.party.getAllyPartiesIterator();
    }

    @Override
    public boolean shouldWork(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, PartyRemovalSpreadoutTask holder) {
        return !this.done;
    }

    @Override
    public boolean shouldDrop(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, PartyRemovalSpreadoutTask holder) {
        return !this.shouldWork(serverData, holder);
    }

    private boolean shouldBeDone() {
        return !this.memberIterator.hasNext() && !this.allyIterator.hasNext() && !this.partyManager.isAlliedByAnyone(this.party.getId());
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, PartyRemovalSpreadoutTask holder, int perTick, List<PartyRemovalSpreadoutTask> tasksToAdd) {
        for (int stepsLeft = perTick; !(this.done = this.shouldBeDone()) && stepsLeft > 0; --stepsLeft) {
            if (this.memberIterator.hasNext()) {
                PartyMember mi = this.memberIterator.next();
                this.partyManager.onMemberRemoved(this.party, mi);
                continue;
            }
            if (this.allyIterator.hasNext()) {
                PartyAlly ally = this.allyIterator.next();
                this.partyManager.onAllyRemoved(this.party, ally.getPartyId(), true);
                continue;
            }
            ServerParty alliedBy = this.partyManager.getPartiesThatAlly(this.party.getId()).findFirst().orElse(null);
            if (alliedBy == null) break;
            alliedBy.removeAllyParty(this.party.getId());
        }
        if (this.done) {
            this.memberIterator = null;
            this.allyIterator = null;
        }
    }
}

