/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.IntSupplier;
import net.coderbot.iris.gl.state.ValueUpdateNotifier;
import net.coderbot.iris.gl.uniform.Uniform;

public class IntUniform
extends Uniform {
    private int cachedValue = 0;
    private final IntSupplier value;

    IntUniform(int location, IntSupplier value) {
        this(location, value, null);
    }

    IntUniform(int location, IntSupplier value, ValueUpdateNotifier notifier) {
        super(location, notifier);
        this.value = value;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        int newValue = this.value.getAsInt();
        if (this.cachedValue != newValue) {
            this.cachedValue = newValue;
            RenderSystem.m_69543_((int)this.location, (int)newValue);
        }
    }
}

