/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.buffer;

import com.mojang.blaze3d.platform.GlStateManager;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.buffer.ShaderStorageInfo;

public class ShaderStorageBuffer {
    protected int id = GlStateManager.m_84537_();
    protected final int index;
    protected final ShaderStorageInfo info;

    public ShaderStorageBuffer(int index, ShaderStorageInfo info) {
        this.index = index;
        this.info = info;
    }

    public final int getIndex() {
        return this.index;
    }

    public final long getSize() {
        return this.info.size();
    }

    protected void destroy() {
        IrisRenderSystem.bindBufferBase(37074, this.index, 0);
        IrisRenderSystem.deleteBuffers(this.id);
    }

    public void bind() {
        IrisRenderSystem.bindBufferBase(37074, this.index, this.id);
    }

    public void resizeIfRelative(int width, int height) {
        if (!this.info.relative()) {
            return;
        }
        IrisRenderSystem.deleteBuffers(this.id);
        int newId = GlStateManager.m_84537_();
        GlStateManager.m_84480_((int)37074, (int)newId);
        int newWidth = (int)((float)width * this.info.scaleX());
        int newHeight = (int)((float)height * this.info.scaleY());
        int finalSize = newHeight * newWidth * this.info.size();
        IrisRenderSystem.bufferStorage(37074, finalSize, 0);
        IrisRenderSystem.clearBufferSubData(37074, 33321, 0L, finalSize, 6403, 5120, new int[]{0});
        IrisRenderSystem.bindBufferBase(37074, this.index, newId);
        this.id = newId;
    }

    public int getId() {
        return this.id;
    }
}

