/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.vertex.postexnormal;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.core.layout.CommonItems;
import com.jozufozu.flywheel.core.layout.LayoutItem;
import com.jozufozu.flywheel.core.vertex.PosTexNormalVertex;
import com.jozufozu.flywheel.core.vertex.PosTexNormalVertexListUnsafe;
import com.jozufozu.flywheel.core.vertex.PosTexNormalWriterUnsafe;
import com.jozufozu.flywheel.util.RenderMath;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.List;
import net.coderbot.iris.vertices.BlockSensitiveBufferBuilder;
import org.lwjgl.system.MemoryUtil;
import top.leonx.irisflw.vertex.IrisBlockVertexReader;
import top.leonx.irisflw.vertex.postexnormal.ExtendedPosTexNormalVertex;

public class ExtendedPosTexNormalWriterUnsafe
extends PosTexNormalWriterUnsafe
implements BlockSensitiveBufferBuilder {
    private short currentBlock = (short)-1;
    private short currentRenderType = (short)-1;
    private int currentLocalPosX;
    private int currentLocalPosY;
    private int currentLocalPosZ;

    public ExtendedPosTexNormalWriterUnsafe(PosTexNormalVertex type, ByteBuffer buffer) {
        super(type, buffer);
    }

    public void writeVertex(VertexList list, int i) {
        super.writeVertex(list, i);
    }

    public void putVertex(float x, float y, float z, float nX, float nY, float nZ, float u, float v) {
        this.putVertexExtended(x, y, z, nX, nY, nZ, u, v, 0.0f, 0.0f, 0, 0);
    }

    public void putVertexExtended(float x, float y, float z, float nX, float nY, float nZ, float u, float v, float midU, float midV, int tangent, int midBlock) {
        MemoryUtil.memPutFloat((long)this.ptr, (float)x);
        MemoryUtil.memPutFloat((long)(this.ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(this.ptr + 8L), (float)z);
        MemoryUtil.memPutFloat((long)(this.ptr + 12L), (float)u);
        MemoryUtil.memPutFloat((long)(this.ptr + 16L), (float)v);
        MemoryUtil.memPutByte((long)(this.ptr + 20L), (byte)RenderMath.nb((float)nX));
        MemoryUtil.memPutByte((long)(this.ptr + 21L), (byte)RenderMath.nb((float)nY));
        MemoryUtil.memPutByte((long)(this.ptr + 22L), (byte)RenderMath.nb((float)nZ));
        MemoryUtil.memPutFloat((long)(this.ptr + 24L), (float)midU);
        MemoryUtil.memPutFloat((long)(this.ptr + 28L), (float)midV);
        MemoryUtil.memPutFloat((long)(this.ptr + 32L), (float)Float.intBitsToFloat(tangent));
        MemoryUtil.memPutFloat((long)(this.ptr + 36L), (float)Float.intBitsToFloat(midBlock));
        MemoryUtil.memPutShort((long)(this.ptr + 40L), (short)this.currentBlock);
        MemoryUtil.memPutShort((long)(this.ptr + 42L), (short)this.currentRenderType);
        this.ptr += 44L;
        this.advance();
    }

    public void beginBlock(short block, short renderType, int localPosX, int localPosY, int localPosZ) {
        this.currentBlock = block;
        this.currentRenderType = renderType;
        this.currentLocalPosX = localPosX;
        this.currentLocalPosY = localPosY;
        this.currentLocalPosZ = localPosZ;
    }

    public void endBlock() {
        this.currentBlock = (short)-1;
        this.currentRenderType = (short)-1;
        this.currentLocalPosX = 0;
        this.currentLocalPosY = 0;
        this.currentLocalPosZ = 0;
    }

    public static class Reader
    extends PosTexNormalVertexListUnsafe
    implements IrisBlockVertexReader {
        private final IntList offsets = new IntArrayList();
        private final int vertexSize;

        public Reader(ByteBuffer copyFrom, int vertexCount) {
            super(copyFrom, vertexCount);
            List elements = ExtendedPosTexNormalVertex.EXTEND_FORMAT.getLayoutItems();
            int offset = 0;
            for (int i = 0; i < elements.size(); ++i) {
                if (elements.get(i) != CommonItems.PADDING_BYTE) {
                    this.offsets.add(offset);
                }
                offset += ((LayoutItem)elements.get(i)).size();
            }
            this.vertexSize = ExtendedPosTexNormalVertex.EXTEND_FORMAT.getStride();
        }

        private long ptr(long index) {
            return this.base + index * (long)this.vertexSize;
        }

        public float getX(int index) {
            return MemoryUtil.memGetFloat((long)this.ptr(index));
        }

        public float getY(int index) {
            return MemoryUtil.memGetFloat((long)(this.ptr(index) + 4L));
        }

        public float getZ(int index) {
            return MemoryUtil.memGetFloat((long)(this.ptr(index) + 8L));
        }

        public float getU(int index) {
            return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(1)));
        }

        public float getV(int index) {
            return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(1) + 4L));
        }

        public float getNX(int index) {
            return RenderMath.f((byte)MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(2))));
        }

        public float getNY(int index) {
            return RenderMath.f((byte)MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(2) + 1L)));
        }

        public float getNZ(int index) {
            return RenderMath.f((byte)MemoryUtil.memGetByte((long)(this.ptr(index) + (long)this.offsets.getInt(2) + 2L)));
        }

        @Override
        public float getMidTexU(int index) {
            return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(3)));
        }

        @Override
        public float getMidTexV(int index) {
            return MemoryUtil.memGetFloat((long)(this.ptr(index) + (long)this.offsets.getInt(3) + 4L));
        }

        @Override
        public int getTangent(int index) {
            return MemoryUtil.memGetInt((long)(this.ptr(index) + (long)this.offsets.getInt(3) + 8L));
        }

        @Override
        public int getMidBlock(int index) {
            return MemoryUtil.memGetInt((long)(this.ptr(index) + (long)this.offsets.getInt(3) + 12L));
        }

        @Override
        public short getEntityX(int index) {
            return MemoryUtil.memGetShort((long)(this.ptr(index) + (long)this.offsets.getInt(4)));
        }

        @Override
        public short getEntityY(int index) {
            return MemoryUtil.memGetShort((long)(this.ptr(index) + (long)this.offsets.getInt(4) + 2L));
        }

        @Override
        public int copyTo(long dst, int index) {
            return 0;
        }
    }
}

