/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.test;

import dev.architectury.platform.Platform;
import dev.architectury.utils.EnvExecutor;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.option.SpruceBooleanOption;
import dev.lambdaurora.spruceui.option.SpruceCheckboxBooleanOption;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleInputOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleOption;
import dev.lambdaurora.spruceui.option.SpruceFloatInputOption;
import dev.lambdaurora.spruceui.option.SpruceIntegerInputOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.option.SpruceSimpleActionOption;
import dev.lambdaurora.spruceui.option.SpruceToggleBooleanOption;
import dev.lambdaurora.spruceui.test.TestEnum;
import dev.lambdaurora.spruceui.test.gui.SpruceMainMenuScreen;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceContainerWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextAreaWidget;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import org.jetbrains.annotations.Nullable;

public class SpruceUITest {
    private static SpruceUITest INSTANCE;
    private final SpruceOption booleanOption;
    private final SpruceOption checkboxOption;
    private final SpruceOption toggleSwitchOption;
    private final SpruceOption separatorOption;
    private final SpruceOption doubleOption;
    private final SpruceOption cyclingOption;
    private final SpruceOption intInputOption;
    private final SpruceOption floatInputOption;
    private final SpruceOption doubleInputOption;
    private final SpruceOption actionOption;
    private final SpruceOption resetOption;
    private boolean aBoolean;
    private boolean checkboxBoolean;
    private boolean toggleBoolean;
    private double aDouble;
    private TestEnum cyclingValue = TestEnum.FIRST;
    private int anInt;
    private float aFloat;
    private double anInputDouble;
    public Consumer<SpruceButtonWidget> resetConsumer;

    public SpruceUITest() {
        EnvExecutor.runInEnv((Dist)Dist.CLIENT, () -> this::onInitializeClient);
        this.booleanOption = new SpruceBooleanOption("spruceui_test.option.boolean", () -> this.aBoolean, newValue -> {
            this.aBoolean = newValue;
        }, (Component)Component.m_237113_((String)"Represents a boolean option, can either be true or false.\nThe option value can be colored."), true);
        this.checkboxOption = new SpruceCheckboxBooleanOption("spruceui_test.option.checkbox", () -> this.checkboxBoolean, newValue -> {
            this.checkboxBoolean = newValue;
        }, (Component)Component.m_237113_((String)"Represents a boolean option as a checkbox, can either be true or false.\nIt's another implementation of `SpruceBooleanOption` internally."), true);
        this.toggleSwitchOption = new SpruceToggleBooleanOption("spruceui_test.option.toggle_switch", () -> this.toggleBoolean, newValue -> {
            this.toggleBoolean = newValue;
        }, (Component)Component.m_237113_((String)"Represents a boolean option as a toggle switch, can either be true or false.\nIt's another implementation of `SpruceBooleanOption` internally."));
        this.separatorOption = new SpruceSeparatorOption("spruceui_test.option.separator", true, null);
        this.doubleOption = new SpruceDoubleOption("spruceui_test.option.double", 0.0, 50.0, 1.0f, () -> this.aDouble, newValue -> {
            this.aDouble = newValue;
        }, option -> option.getDisplayText((Component)Component.m_237113_((String)String.valueOf(this.aDouble))), (Component)Component.m_237113_((String)"Represents an option with a floating point value.\nThere is a minimum, a maximum and a step.\nThere is also a lambda for the display text as you can integrate a suffix/prefix like \"%\" or anything else."));
        this.cyclingOption = new SpruceCyclingOption("spruceui_test.option.cycling", amount -> {
            this.cyclingValue = this.cyclingValue.next();
        }, option -> option.getDisplayText(this.cyclingValue.getText()), (Component)Component.m_237113_((String)"Represents a cycling option.\nEach press will cycle the value between some pre-defined values."));
        this.intInputOption = new SpruceIntegerInputOption("spruceui_test.option.int_input", () -> this.anInt, value -> {
            this.anInt = value;
        }, (Component)Component.m_237113_((String)"Represents an option with an integer value as text."));
        this.floatInputOption = new SpruceFloatInputOption("spruceui_test.option.float_input", () -> Float.valueOf(this.aFloat), value -> {
            this.aFloat = value.floatValue();
        }, (Component)Component.m_237113_((String)"Represents an option with a float value as text."));
        this.doubleInputOption = new SpruceDoubleInputOption("spruceui_test.option.double_input", () -> this.anInputDouble, value -> {
            this.anInputDouble = value;
        }, (Component)Component.m_237113_((String)"Represents an option with a double value as text."));
        this.actionOption = SpruceSimpleActionOption.of("spruceui_test.option.action", btn -> {
            Minecraft client = Minecraft.m_91087_();
            SystemToast toast = SystemToast.m_94847_((Minecraft)client, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237113_((String)"Action button pressed!"), (Component)Component.m_237113_((String)"I'm a result of the action"));
            client.m_91300_().m_94922_((Toast)toast);
        }, (Component)Component.m_237113_((String)"Represents an option with a simple action.\nIt's used like a normal button and a press callback."));
        this.resetOption = SpruceSimpleActionOption.reset(btn -> {
            this.aBoolean = false;
            this.checkboxBoolean = false;
            this.aDouble = 0.0;
            this.cyclingValue = TestEnum.FIRST;
            if (this.resetConsumer != null) {
                this.resetConsumer.accept(btn);
            }
        }, (Component)Component.m_237113_((String)"Represents a reset option.\nThe option title is already defined and translated in several languages.\nYou have to manage screen re-initialization and reset logic yourself."));
    }

    public void onInitializeClient() {
        Platform.getMod((String)"spruceui").registerConfigurationScreen(SpruceMainMenuScreen::new);
        INSTANCE = this;
    }

    public SpruceOptionListWidget buildOptionList(Position position, int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(position, width, height);
        list.addOptionEntry(this.booleanOption, this.checkboxOption);
        list.addOptionEntry(this.toggleSwitchOption, null);
        list.addOptionEntry(this.toggleSwitchOption, null);
        list.addOptionEntry(this.toggleSwitchOption, null);
        list.addOptionEntry(this.toggleSwitchOption, null);
        list.addOptionEntry(this.toggleSwitchOption, null);
        list.addSingleOptionEntry(this.separatorOption);
        list.addSingleOptionEntry(this.doubleOption);
        list.addSingleOptionEntry(this.intInputOption);
        list.addSingleOptionEntry(this.floatInputOption);
        list.addSingleOptionEntry(this.doubleInputOption);
        list.addOptionEntry(this.actionOption, this.cyclingOption);
        return list;
    }

    public static SpruceContainerWidget buildTextAreaContainer(Position position, int width, int height, Consumer<SpruceTextAreaWidget> textAreaConsumer, @Nullable SpruceButtonWidget.PressAction doneButtonAction) {
        int textFieldWidth = (int)((double)width * 0.75);
        SpruceTextAreaWidget textArea = new SpruceTextAreaWidget(Position.of(width / 2 - textFieldWidth / 2, 0), textFieldWidth, height - 50, (Component)Component.m_237113_((String)"Text Area"));
        textArea.setLines(Arrays.asList("Hello world,", "", "Today I want to present you this text area.", "I hope you like it, spent 2 whole days on this stupid widget.", "", "The underlying implementation was kind of hard to write, especially when the first design had a stupid choice.", "The widget uses a list of strings to store the text, each index of the list represents one row, not one line.", "The first implementation made the error of making it per line, which made rendering very hard and overflowing issues happened", "", "Now it has to convert list of lines to list of rows, it's really not funny to do...", "", "Feature-wise!", " - Arrow keys allows you to move the cursor", " - HOME and END keys work", " - You can select text", " - You can copy/cut/paste text.", " - You can delete a row with CTRL + D", " - CTRL + A selects everything", "", "This widget can be very useful in some cases."));
        textAreaConsumer.accept(textArea);
        textArea.setCursorToStart();
        SpruceContainerWidget container = new SpruceContainerWidget(position, width, height);
        container.addChild(textArea);
        int printToConsoleX = width / 2 - (doneButtonAction == null ? 75 : 155);
        container.addChild(new SpruceButtonWidget(Position.of(printToConsoleX, height - 29), 150, 20, (Component)Component.m_237113_((String)"Print to console"), btn -> {
            System.out.println("########################## START TEXT AREA CONTENT ##########################");
            System.out.println(textArea.getText());
            System.out.println("##########################  END TEXT AREA CONTENT  ##########################");
        }));
        if (doneButtonAction != null) {
            container.addChild(new SpruceButtonWidget(Position.of(width / 2 - 155 + 160, height - 29), 150, 20, SpruceTexts.GUI_DONE, doneButtonAction));
        }
        return container;
    }

    public static SpruceUITest get() {
        return INSTANCE;
    }
}

