/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.util;

import com.obscuria.obscureapi.network.PlayerDataCapability;
import com.obscuria.obscureapi.util.TextUtils;
import com.obscuria.obscureapi.util.WorldUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class PlayerUtils {
    public static CompoundTag getData(Player player) {
        return ((PlayerDataCapability.PlayerData)player.getCapability(PlayerDataCapability.OBS_DATA, null).orElse((Object)new PlayerDataCapability.PlayerData())).tag;
    }

    public static CompoundTag getData(Player player, String name) {
        return PlayerUtils.getData(player).m_128469_(name);
    }

    public static void putData(Player player, CompoundTag tag) {
        player.getCapability(PlayerDataCapability.OBS_DATA, null).ifPresent(capability -> {
            capability.tag = tag;
            capability.syncPlayerData((Entity)player);
        });
    }

    public static void putData(Player player, String name, CompoundTag data) {
        CompoundTag tag = PlayerUtils.getData(player);
        if (tag.m_128441_(name)) {
            tag.m_128473_(name);
        }
        tag.m_128365_(name, (Tag)data);
        PlayerUtils.putData(player, tag);
    }

    public static void sendMessage(@Nullable Player player, String text) {
        if (player != null) {
            player.m_5661_((Component)TextUtils.component(text), false);
        }
    }

    public static void sendSystemMessage(@Nullable Player player, String text) {
        if (player != null) {
            player.m_213846_((Component)TextUtils.component(text));
        }
    }

    public static boolean hasCooldown(Player player, Item item) {
        return player.m_36335_().m_41519_(item);
    }

    public static boolean cooldownItem(Player player, Item item, int ticks) {
        if (!PlayerUtils.hasCooldown(player, item)) {
            player.m_36335_().m_41524_(item, ticks);
            return true;
        }
        return false;
    }

    public static boolean hasCooldown(Player player, ItemStack stack) {
        return PlayerUtils.hasCooldown(player, stack.m_41720_());
    }

    public static boolean cooldownItem(Player player, ItemStack stack, int ticks) {
        return PlayerUtils.cooldownItem(player, stack.m_41720_(), ticks);
    }

    public static void forceItemCooldown(Player player, Item item, int ticks) {
        player.m_36335_().m_41524_(item, ticks);
    }

    public static void forceItemCooldown(Player player, ItemStack stack, int ticks) {
        player.m_36335_().m_41524_(stack.m_41720_(), ticks);
    }

    public static void damageItem(Player player, ItemStack stack, InteractionHand hand, int damage) {
        stack.m_41622_(damage, (LivingEntity)player, entity -> player.m_21190_(hand));
    }

    public static void giveItem(Player player, Item item) {
        PlayerUtils.giveItem(player, item.m_7968_());
    }

    public static void giveItem(Player player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            WorldUtils.dropItem(player.f_19853_, player.m_20183_(), stack, new Vec3(0.0, 0.25, 0.0));
        }
    }

    public static ItemStack findItem(Player player, Predicate<ItemStack> predicate) {
        if (predicate.test(player.m_21205_())) {
            return player.m_21205_();
        }
        if (predicate.test(player.m_21206_())) {
            return player.m_21206_();
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!predicate.test(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }
}

